#ifndef _IVBDEFS_
  #define _IVBDEFS_

/*******************************************************************************
* FILE NAME: ivbdefs.h                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the defines and macros for the Visual Builder.              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*******************************************************************************/
#ifndef IVB_IMPORT
  #if defined(__WINDOWS__) && defined(__IMPORTLIB__)
    #define IVB_IMPORT  _Import
  #else
    #define IVB_IMPORT
  #endif
#endif


#ifndef VBINITIALIZEID
  #define VBINITIALIZEID 0
#endif

#ifndef VBBASEWINDOWID
  #define VBBASEWINDOWID 15000
#endif

#ifndef VBINFOAREATEXTOFFSET
  #define VBINFOAREATEXTOFFSET 0
#endif

#ifndef VBSHORTFLYTEXTOFFSET
  #define VBSHORTFLYTEXTOFFSET 5000
#endif

#ifndef VBLONGFLYTEXTOFFSET
  #define VBLONGFLYTEXTOFFSET 10000
#endif

#ifndef VBPOINT
#define VBPOINT( pmX , pmY , winX , winY )\
  ((ICoordinateSystem::applicationOrientation() == ICoordinateSystem::originLowerLeft)\
     ? IPoint(pmX, pmY) : IPoint(winX, winY))
#endif

#ifndef VBSTRINGRC
#define VBSTRINGRC( resourceId )\
  IApplication::current().userResourceLibrary().tryToLoadString( resourceId )
#endif

#ifndef VBINTVALUEFROMTEXT
#define VBINTVALUEFROMTEXT()\
  text().asInt()
#endif

#ifndef VBUNSIGNEDVALUEFROMTEXT
#define VBUNSIGNEDVALUEFROMTEXT()\
  text().asUnsigned()
#endif

#ifndef VBDOUBLEVALUEFROMTEXT
#define VBDOUBLEVALUEFROMTEXT()\
  text().asDouble()
#endif

#ifndef VBISDIGITSFROMTEXT
#define VBISDIGITSFROMTEXT()\
  text().isDigits()
#endif

#ifndef VBLENGTHFROMTEXT
#define VBLENGTHFROMTEXT()\
  text().length()
#endif

#ifndef VBSETTEXTFROMVALUE
#define VBSETTEXTFROMVALUE( newValue )\
  setText(IString(newValue))
#endif

#ifndef VBSELECTIONTEXT
#define VBSELECTIONTEXT()\
  itemText(source->selection())
#endif

#ifndef FOCUSTRUEID
  #define FOCUSTRUEID focusId && ((Boolean)anEvent.eventData())
#endif

#ifndef FOCUSFALSEID
  #define FOCUSFALSEID focusId && (!((Boolean)anEvent.eventData()))
#endif

#ifndef ENABLETRUEID
  #define ENABLETRUEID enableId && ((Boolean)anEvent.eventData())
#endif

#ifndef ENABLEFALSEID
  #define ENABLEFALSEID enableId && (!((Boolean)anEvent.eventData()))
#endif

#ifndef VISIBLETRUEID
  #define VISIBLETRUEID visibleId && ((Boolean)anEvent.eventData())
#endif

#ifndef VISIBLEFALSEID
  #define VISIBLEFALSEID visibleId && (!((Boolean)anEvent.eventData()))
#endif

#ifndef VALUETRUEID
  #define VALUETRUEID valueId && ((Boolean)anEvent.eventData())
#endif

#ifndef VALUEFALSEID
  #define VALUEFALSEID valueId && (!((Boolean)anEvent.eventData()))
#endif

#ifdef __OS2__
  #ifndef VBXLATEMNEMONIC
    #define VBXLATEMNEMONIC(string) (string)
  #endif
#endif
#ifdef __WINDOWS__
  #ifndef VBXLATEMNEMONIC
    #define VBXLATEMNEMONIC(string) (IVBMnemonicString::translateMnemonic(string))
  #endif
#endif

#endif
