#
# FILE NAME: ivbdefs.mak
#
# DESCRIPTION:
#   Visual Builder makefile logic.
#
# COPYRIGHT:
#   IBM(R) VisualAge(TM) for C++
#   (C) Copyright International Business Machines Corporation 1991, 1996
#   Licensed Material - Program-Property of IBM - All Rights Reserved.
#   US Government Users Restricted Rights - Use, duplication, or disclosure
#   restricted by GSA ADP Schedule Contract with IBM Corp.
#
#   This program will not run in DOS mode.
#

!ifndef VBOS2
!ifndef VBWIN
!ifdef OS2_SHELL
VBOS2=1
!else
VBWIN=1
!endif
!endif
!endif

!ifndef VBOS2
VBWIN=1
VBIRC=irc
!else
!undef VBWIN
VBIRC=rc
!endif

!ifndef VBCPPFLAGS
VBCPPFLAGS=/Ft$(BASENAME) /Gm+ /Tdp /Gd+ /I. /Q
!ifndef VBDEBUG
VBCPPFLAGS=$(VBCPPFLAGS) /O+
!else
VBCPPFLAGS=$(VBCPPFLAGS) /Ti+ /DIC_TRACE_DEVELOP
!endif
!endif

!ifndef VBAPPFLAGS
!ifdef VBRESDLL
VBAPPFLAGS=/Ft$(BASENAME) /Gm+ /Tdp /Gd+ /I. /Q /DVBRESDLL="\"$(VBRESDLL)\""
!else
VBAPPFLAGS=/Ft$(BASENAME) /Gm+ /Tdp /Gd+ /I. /Q
!endif
!ifndef VBDEBUG
VBAPPFLAGS=$(VBAPPFLAGS) /O+
!else
VBAPPFLAGS=$(VBAPPFLAGS) /Ti+ /DIC_TRACE_DEVELOP
!endif
!endif

.SUFFIXES: .app .rcx .cpp

.app{$(VBOBJ)}.o:
        @echo $(CC) %s creating $(VBOBJ)%|dpfF.o ... >con
        $(CC) /c $(VBAPPFLAGS) /Fo"$(VBOBJ)%|dpfF.o" %s

.cpp{$(VBOBJ)}.obj:
        @echo $(CC) %s creating $(VBOBJ)%|dpfF.obj  ... >con
        $(CC) /c $(VBCPPFLAGS) /Fo"$(VBOBJ)%|dpfF.obj" %s

.rcx.rc:
        @echo $(CC) %s creating $(*F).rc ... >con
        $(CC) -c /Pc+ /Pe+ /I. /Q %s
        - if exist $(*F).rc erase $(*F).rc
        rename $(*F).i $(*F).rc

.rc{$(VBOBJ)}.res:
        @echo $(VBIRC) %s creating $(*F).res ... >con
        $(VBIRC) -r $(*F).rc
