#ifndef _IVBDRAGH_
  #define _IVBDRAGH_

/*******************************************************************************
* FILE NAME: ivbdragh.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBDragDropHandler             - Drag/Drop Handler                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
*******************************************************************************/

#ifndef _IDMHNDLR_
  #include <idmhndlr.hpp>
#endif

#ifndef _IHANDLER_
  #include <ihandler.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

class IWindow;
class IEntryField;
class IMultiLineEdit;
class IContainerControl;
class IToolBarButton;
class IToolBar;
class IMenuBar;
class ISubmenu;

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

//**************************************************************************
// Class:   IVBDragDropHandler                                             *
//                                                                         *
// Purpose: Subclass of IHandler so that make it easy to add drag/drop     *
//          to a control.                                                  *
//                                                                         *
//**************************************************************************
class IVBDragDropHandler : public IHandler
{
public:
  IVBDragDropHandler ();

virtual IHandler
 &handleEventsFor ( IWindow * window ),
 &handleEventsFor ( IEntryField * window ),
 &handleEventsFor ( IMultiLineEdit * window ),
 &handleEventsFor ( IContainerControl * window ),
 &handleEventsFor ( IToolBarButton * window ),
 &handleEventsFor ( IMenuBar * window ),
 &handleEventsFor ( IToolBar * window ),
 &stopHandlingEventsFor ( IWindow *window );

protected:
  virtual Boolean dispatchHandlerEvent ( IEvent &evt );
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
