#ifndef _IVBDTYPE_
  #define _IVBDTYPE_
/*******************************************************************************
* FILE NAME: ivbdtype.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBDataTypePart - IBM VB sample base data type part.                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/
#ifndef _IVBDEFS__
#include <ivbdefs.h>
#endif

#ifndef _ISTDNTFY_
  #include <istdntfy.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03.LIB")
    #endif
  #endif
#endif


/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBDataTypePart : public IStandardNotifier
{
typedef IStandardNotifier
  Inherited;
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------- Constructors/Destructor ----------------------------
------------------------------------------------------------------------------*/
  IVBDataTypePart ();
virtual
  ~IVBDataTypePart ();

  IVBDataTypePart& operator= (const IVBDataTypePart& aIVBDataTypePart);

Boolean
  operator == (const IVBDataTypePart& aValue) const,
  operator != (const IVBDataTypePart& aValue) const,
  operator == (const IVBDataTypePart* aValue) const,
  operator != (const IVBDataTypePart* aValue) const,
  operator < (const IVBDataTypePart& aValue) const,
  operator < (const IVBDataTypePart* aValue) const,
  operator < (IVBDataTypePart* const& aValue) const;

/*----------------------- Notification Event Descriptions ----------------------
| List of attribute and event notification identifiers:                        |
|                                                                              |
|  valueId             - Notification event for value attribute.               |
|  defaultValueId      - Notification event for defaultValue attribute.        |
|  valueEqualDefaultId - Notification event for valueEqualDefault.             |
|  valueNotEqualDefaultId - Notification event for valueNotEqualDefault.       |
|  lowLimitId          - Notification event for lowLimit attribute.            |
|  highLimitId         - Notification event for highLimit attribute.           |
|  valueEqualLowLimitId - Notification event for valueEqualLowLimit.           |
|  valueEqualHighLimitId - Notification event for valueEqualHighLimit.         |
|  valueBelowLowLimitId - Notification event for valueBelowLowLimit.           |
|  valueAboveHighLimitId - Notification event for valueAboveHighLimit.         |
|  valueOutsideLimitsId - Notification event for valueOutsideLimits.           |
|  valueWithinLimitsId - Notification event for valueWithinLimits.             |
|  valueNotZeroId      - Notification event for valueNotZero.                  |
|  valueZeroId         - Notification event for valueZero.                     |
|  valuePositiveId     - Notification event for valuePositive.                 |
|  valueNegativeId     - Notification event for valueNegative.                 |
|  textId              - Notification event for text attribute.                |
|  defaultTextId       - Notification event for defaultText attribute.         |
|  textEqualDefaultId  - Notification event for textEqualDefault.              |
|  textNotEqualDefaultId - Notification event for textNotEqualDefault.         |
|  textLengthId        - Notification event for textLength attribute.          |
|  lowerCaseId         - Notification event for lowerCase.                     |
|  upperCaseId         - Notification event for upperCase.                     |
|  digitsId            - Notification event for digits.                        |
|  inputStringNotValidId - Notification event for string not valid.            |
|  inputStringIsValidId - Notification event for string is valid.              |
------------------------------------------------------------------------------*/

static INotificationId const
  IVB_IMPORT valueId,
  IVB_IMPORT defaultValueId,
  IVB_IMPORT valueEqualDefaultId,
  IVB_IMPORT valueNotEqualDefaultId,
  IVB_IMPORT lowLimitId,
  IVB_IMPORT highLimitId,
  IVB_IMPORT valueEqualLowLimitId,
  IVB_IMPORT valueEqualHighLimitId,
  IVB_IMPORT valueBelowLowLimitId,
  IVB_IMPORT valueAboveHighLimitId,
  IVB_IMPORT valueOutsideLimitsId,
  IVB_IMPORT valueWithinLimitsId,
  IVB_IMPORT valueNotZeroId,
  IVB_IMPORT valueZeroId,
  IVB_IMPORT valuePositiveId,
  IVB_IMPORT valueNegativeId,
  IVB_IMPORT textId,
  IVB_IMPORT defaultTextId,
  IVB_IMPORT textEqualDefaultId,
  IVB_IMPORT textNotEqualDefaultId,
  IVB_IMPORT textLengthId,
  IVB_IMPORT lowerCaseId,
  IVB_IMPORT upperCaseId,
  IVB_IMPORT digitsId,
  IVB_IMPORT inputStringNotValidId,
  IVB_IMPORT inputStringIsValidId;

};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
