#ifndef _IVBFILED_
  #define _IVBFILED_
/*******************************************************************************
* FILE NAME: ivbfiled.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declaration(s) of the class(es):                    *
*     IVBFileDialog - A surrogate of the IFileDialog class.                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
*******************************************************************************/
#ifndef _IVBDEFS__
#include <ivbdefs.h>
#endif

#ifndef _ISTDNTFY_
  #include <istdntfy.hpp>
#endif

#ifndef _IFILEHDR_
  #include <ifilehdr.hpp>
#endif

#ifndef _IFILEDLG_
  #include <ifiledlg.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

//Forward declarations for other classes:
class IVBFileDialogData;

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBFileDialog : public IStandardNotifier
{
typedef IStandardNotifier
  Inherited;
/*******************************************************************************
*                                                                              *
* A surrogate of the IFileDialog class.                                        *
*                                                                              *
* An instance of this class provides an instance of the IFileDialog::Settings  *
* and a protocol to set the member data.                                       *
* Calling either IFileDialog::show or showModally will construct a new         *
* instance of IFileDialog using the instance settings and owner together       *
* with the member function parameters parent, style and handler.               *
*                                                                              *
* Accessor methods are provided to the instance of either IFileDialog or       *
* IFileDialog::Settings. Instances of this class do not forward notifications  *
* of either IFileDialog or IFileDialog::Settings.                              *
*                                                                              *
* Example:                                                                     *
*   IVBFileDialog  fd( owner );                                                *
*   fd.setTitle( "Select a file" ).setOKButtonText( "Select" );                *
*   do {     //wait for user to press "Select"                                 *
*      fd.showModally( );               //default style = single select        *
*      } while ( !fd.pressedOK());                                             *
*   processFile( fd.fileName());        //member function to process file      *
*                                                                              *
********************************************************************************/
public:

/*------------------------ Constructors/Destructor -----------------------------
| You can construct an instance of this class in one way:                      |
|     - Using a constructor that takes an owner.                               |
|                                                                              |
|------------------------------------------------------------------------------*/
  IVBFileDialog(IWindow*    owner);
virtual
 ~IVBFileDialog( );

/*------------------------------ Display dialog --------------------------------
|   showModally - Causes a application-modal dialog to be displayed.           |
|   show        - Causes the dialog to be made visible.   The default mode is  |
|                 modal.  If you require a modeless dialog, you must set the   |
|                 modeless style bit in the Style argument.                    |
|   Note: Only one instance of IFileDialog may be showing at any time,         |
|         showModally or show may not be called a second time until the first  |
|         called instance of the dialog has been dismissed.                    |
|         A modal dialog has been dismissed when the caller is returned        |
|         control after a showModally or show.                                 |
|         The results from showing a dialog are loss when showModally or       |
|         show are called again.                                               |
|                                                                              |
------------------------------------------------------------------------------*/
virtual unsigned long
  showModally   ( IWindow*                   parent  = NULL
                , const IFileDialog::Style   style   = IFileDialog::defaultStyle()
                , IHandler*                  handler = 0 );
virtual IVBFileDialog
 &show          ( IWindow*                   parent
                , const IFileDialog::Style   style   = IFileDialog::defaultStyle()
                , IHandler*                  handler = 0 );

/*---------------- Getting Information About the Dialog ------------------------
| These functions provide ways to get information about the dialog:            |
|    isModeless      - Returns true if this is a modeless dialog.              |
|    pressedOK       - Returns true if the user ended the dialog by pressing   |
|                      the OK push button.                                     |
|    buttonPressedId - Returns the ID of the push button that was used to      |
|                      dismiss the dialog.                                     |
|    returnValue     - Returns the return code, if an error occurred.          |
|      Note: These member functions are valid only after a dialog is           |
|            dismissed.                                                        |
|                                                                              |
------------------------------------------------------------------------------*/
Boolean
  isModeless              ( ) const,
  pressedOK               ( ) const;

long
  buttonPressedId         ( ) const,
  returnValue             ( ) const;

/*----------- Getting Information About the Chosen File ------------------------
| These functions provide ways to get information about the file that was      |
| selected in the file dialog:                                                 |
|    selectedFileCount - Returns the number of files selected by the user.     |
|                        This number can be more than one if the dialog was    |
|                        created with IFileDialog::multiSelection.             |
|    fileName          - Returns the fully qualified file name selected by     |
|                        the user.  When multiSelection is used, you should    |
|                        call this function with the fileNumber parameter set  |
|                        from 0 to selectedFileCount - 1, to ensure the        |
|                        correct number of files is returned.                  |
|    saveAsEAType      - Returns the extended-attribute for a Save As dialog.  |
|                        This is the type the user chose from the drop-down    |
|                        list of EA types.  If <All Files> was the chosen EA   |
|                        type, then this returns a 0-length IString.           |
|      Note: These member functions are valid only after a dialog is           |
|            dismissed.                                                        |
------------------------------------------------------------------------------*/
unsigned long
  selectedFileCount       ( ) const;

IString
  fileName                (unsigned long fileNumber = 0) const;

#ifdef __OS2__
IString
  saveAsEAType            ( ) const;
#endif

/*---------------- Setting Information About the Dialog ------------------------
|  See the IFileDialog for specifics on any member function.                   |
------------------------------------------------------------------------------*/
virtual  IVBFileDialog
 &setOpenDialog           ( ),
 &setSaveAsDialog         ( ),
 &setTitle                ( const char*        newTitle   ),
 &setTitle                ( const IResourceId& resId      ),
 &setOKButtonText         ( const char*        newText    ),
 &setOKButtonText         ( const IResourceId& resId      ),
 &setInitialFileType      ( const char*        fileType   ),
 &setFileName             ( const char*        fileName   ),
 &setInitialDrive         ( const char*        drive      ),
 &setDialogTemplate       ( const IResourceId& resourceId ),
 &setPosition             ( const IPoint&      position   );

#ifdef __OS2__
virtual  IVBFileDialog
 &addFileType             ( const char*        fileType   ),
 &addDrive                ( const char*        drive      );
#endif

/*----------------------- Access to Settings and Dialog ------------------------
| These functions provide ways to get addressability to the IFileDialog and    |
| it's Settings (useful with tear-off attributes or access to methods not      |
| externalized by this class):                                                 |
|    fileDialog        - Returns a pointer to the IFileDialog instance         |
|    fileDialogSettings- Returns a pointer to the IFileDialog::Settings        |
|                        instance.                                             |
------------------------------------------------------------------------------*/
IFileDialog
 *fileDialog( );
IFileDialog::Settings
 *fileDialogSettings( );

/*----------------------- Notification Event Descriptions ----------------------
| These INotificationId strings are used for all notifications that            |
| IVBFileDialog provides to its observers:                                     |
|   createdId   - Notification identifier provided to observers when a new     |
|                 IFileDialog has been created.                                |
|   dismissedId - Notification identifier provided to observers when the       |
|                 showing IFileDialog has been dismissed.                      |
|   pressedOkId - Notification identifier provided to observers when the       |
|                 showing IFileDialog has been dismissed with ok button.       |
------------------------------------------------------------------------------*/
static INotificationId const
  IVB_IMPORT createdId,
  IVB_IMPORT pressedOkId,
  IVB_IMPORT dismissedId;

private:
/*------------------------------- PRIVATE ------------------------------------*/
class IDismissFileDialogDetector;

IWindow
 *pOwner;
IFileDialog::Settings
  settings;
IFileDialog
 *pFileDialog;
IDismissFileDialogDetector
 *pDismissHandler;
Boolean
  bShowing;
IVBFileDialogData
 *fileDialogProxyData;

/*--------------------------- Blocked class methods ----------------------------
| Both the copy constructor and assignment operator are not supported.         |
|                                                                              |
------------------------------------------------------------------------------*/
  IVBFileDialog( const IVBFileDialog & rhs );     // copy ctor
IVBFileDialog
 &operator=( const IVBFileDialog& rhs );             // assignment

/*--------------------- Report detection of dialog end -------------------------
| This function provides a means to notify observers when a modeless           |
| IFileDialog is dismissed.                                                    |
|   dialogEndDetected     - cause notification when a dialog is dismissed.     |
------------------------------------------------------------------------------*/
virtual IVBFileDialog
 &dialogEndDetected( );


class  IDismissFileDialogDetector : public IFileDialogHandler
{
public:
/*------------------------------- Constructor ----------------------------------
| The only way to construct an instance of this class is by using the          |
| default constructor.                                                         |
------------------------------------------------------------------------------*/
  IDismissFileDialogDetector( );
virtual
 ~IDismissFileDialogDetector( );

/*------------------------- Detection of dialog end ----------------------------
| This function provides a means to notify observers when a modeless           |
| IFileDialog ends.                                                            |
|    listenForResults     - begin listening for dimissal of a modeless dialog  |
|    modelessResults      - detect the dimissal of a modeless dialog           |
------------------------------------------------------------------------------*/
virtual IDismissFileDialogDetector
 &listenForResults( IVBFileDialog* pFileDialogProxy );
virtual Boolean
  modelessResults( IFileDialog* endingDialog );

private:

IVBFileDialog
 *proxy;

};   // end IDismissFileDialogDetector

friend IDismissFileDialogDetector::modelessResults( IFileDialog* );

};  // end IVBFileDialog

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing and warning messages.                      */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* _IVBFILED_ */
