#ifndef _IVBFLY_
#define _IVBFLY_
/*******************************************************************************
* FILE NAME: ivfly.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declaration(s) of the class(es):                    *
*     IVBFlyText                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
*******************************************************************************/

#ifndef _IFLYTEXT_
  #include <iflytext.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

class IFlyOverHelpHandler;

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBFlyText : public IFlyText
{
public:

/*------------------------- Constructors -------------------------------------*/
  IVBFlyText         ( IWindow * owner );
virtual
 ~IVBFlyText         ( );

/*-------------------------------- Attributes ----------------------------------
------------------------------------------------------------------------------*/
IFlyOverHelpHandler
 *flyOverHelpHandler ( );

IVBFlyText
 &enableFlyOverHelp  ( Boolean        enable = true ),
 &disableFlyOverHelp ( );
Boolean
  isFlyOverHelp      ( ) const;

IVBFlyText
 &setLongTextControl ( ITextControl*  longText );
ITextControl
 *longTextControl    ( ) const;

virtual IWindow
 &setOwner           ( const IWindow* newOwner );

protected:

IFlyOverHelpHandler
 *flyOver;

private:

Boolean
  flyOverHelpEnabled;

IWindow
  *ftOwner;

} ;

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
