#ifndef _IVBFONTD_
  #define _IVBFONTD_
/*******************************************************************************
* FILE NAME: ivbfontd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the declaration(s) of the class(es):                    *
*     IVBFontDialog - A surrogate of the IFontDialog class.                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
*******************************************************************************/
#ifndef _IVBDEFS__
#include <ivbdefs.h>
#endif

#ifndef _ISTDNTFY_
  #include <istdntfy.hpp>
#endif

#ifndef _IFONTDLG_
  #include <ifontdlg.hpp>
#endif

#ifndef _IFONT_
  #include <ifont.hpp>
#endif

#ifndef _IFONTHDR_
  #include <ifonthdr.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

//Forward declarations for other classes:
class IVBFontDialogData;
class IWindow;
class IFont;

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBFontDialog : public IStandardNotifier
{
typedef IStandardNotifier
  Inherited;
/*******************************************************************************
* The IVBFontDialog class manages access to a IFontDialog::Settings and        *
* showing a IFontDialog object.                                                *
*                                                                              *
* An object of this class creates a IFontDialog::Settings object.              *
* Calling a member funtion in the Display Dialog group will construct and show *
* a new IFontDialog object from the local settings object and owner together   *
* with the member function parameters parent, style and handler.               *
* Objects of this class do not forward notifications of either IFontDialog     *
* or IFontDialog::Settings.                                                    *
*                                                                              *
* Example:                                                                     *
*   IVBFontDialog  fd( owner );                                                *
*   fd.setTitle( "Select a font" ).setOKButtonText( "Select" );                *
*   do {                                                                       *
*      fd.showModally( );               //wait for user to press "Select"      *
*      } while ( !fd.pressedOK());                                             *
*   processFont( fd.fontFamily());      //member function to process font      *
*                                                                              *
********************************************************************************/
public:

/*------------------------ Constructors/Destructor -----------------------------
| You can construct an object of this class:                                   |
|   - From an owner window pointer.                                            |
|                                                                              |
|------------------------------------------------------------------------------*/
  IVBFontDialog (IWindow*    owner);

virtual
 ~IVBFontDialog ( );

/*------------------------------ Display Dialog --------------------------------
| These member functions create and show a IFontDialog:                        |
|   showModally              - Results in an application-modal IFontDialog     |
|                              being displayed.                                |
|   setFontFromWindowModally - Results in an application-modal IFontDialog     |
|                              being displayed. The target window font is      |
|                              used as the default font.  If the dialog is     |
|                              dismissed with OK the selected font is set in   |
|                              the target window.                              |
|   setFontFromFontModally   - Results in an application-modal IFontDialog     |
|                              being displayed.    The target font is used as  |
|                              the default font.   If the dialog is dismissed  |
|                              with OK the selected font is set in the target  |
|                              font.                                           |
|   show                     - Results in a IFontDialog being made visible.    |
|                              The default mode is modal.  If you require a    |
|                              modeless dialog, you must set the modeless      |
|                              style bit in the Style argument.                |
|   showFromFont             - Results in a IFontDialog being made visible.    |
|                              The default mode is modal.  If you require a    |
|                              modeless dialog, you must set the modeless      |
|                              style bit in the Style argument.                |
|   Note: Only one instance of IFontDialog may be showing at any time,         |
|         a second member function may not be called a second time until       |
|         the first called member function has been dismissed.                 |
|         A modal dialog has been dismissed when the caller is returned        |
|         control.  The results from showing a dialog are loss when            |
|         the next Display Dialog group member function is called.             |
|                                                                              |
------------------------------------------------------------------------------*/
virtual unsigned long
  showModally              ( IWindow*                   parent  = NULL
                           , const IFontDialog::Style   style   = IFontDialog::defaultStyle()
                           , IHandler*                  handler = 0 ),
  setFontFromWindowModally ( IWindow*                   target
                           , IWindow*                   parent  = NULL
                           , const IFontDialog::Style   style   = IFontDialog::defaultStyle()
                           , IHandler*                  handler = 0 ),
  setFontFromFontModally   ( IFont*                     target
                           , IWindow*                   parent  = NULL
                           , const IFontDialog::Style   style   = IFontDialog::defaultStyle()
                           , IHandler*                  handler = 0 );

virtual IVBFontDialog
 &show                     ( IWindow*                   parent
                           , const IFontDialog::Style   style   = IFontDialog::defaultStyle()
                           , IHandler*                  handler = 0 ),
 &showFromFont             ( IFont*                     target
                           , IWindow*                   parent
                           , const IFontDialog::Style   style   = IFontDialog::defaultStyle()
                           , IHandler*                  handler = 0 );

/*---------------- Getting Information About the Dialog ------------------------
| These member functions allow querying information about the dialog:          |
|   isModeless      - Returns true if the dismissed dialog was modeless.       |
|   pressedOK       - Returns true if the user ended the dialog by pressing    |
|                     the OK push button.                                      |
|   buttonPressedId - Returns the ID of the push button that was used to       |
|                     dismiss the dialog.                                      |
|   returnValue     - Returns the return code, if an error occurred.           |
|     Note: These member functions are valid only after a dialog is            |
|           dismissed.                                                         |
|                                                                              |
------------------------------------------------------------------------------*/
Boolean
  isModeless              ( ) const,
  pressedOK               ( ) const;
unsigned long
  buttonPressedId         ( ) const;
long
  returnValue             ( ) const;

/*---------------- Getting Information About the Chosen Font -------------------
| These member functions allow querying information about the selected font:   |
|    fontFamily       - Returns the font's family name.                        |
|    fontWeight       - Returns the weight class (boldness) of the font.       |
|    fontWidth        - Returns the width class of the font.                   |
|    emHeight         - Returns the height of the Em square for the font.      |
|    xHeight          - Returns the height above the baseline for lowercase    |
|                       letters.                                               |
|    externalLeading  - Returns the amount of white space between lines of     |
|                       text.                                                  |
|    pointSize        - Returns the font's point size.                         |
|    nominalPointSize - For a bit-map font, this returns the height of the     |
|                       font.  For a vector font, this is the optimal size     |
|                       for the font.                                          |
------------------------------------------------------------------------------*/
IFont
  font                   ( ) const;

virtual IVBFontDialog
 &setFont                (const IFont& font);

#ifdef __OS2__
IString
  fontFamily             ( ) const;
#endif

#ifdef __OS2__
unsigned long
  fontWeight             ( ) const,
  fontWidth              ( ) const,
  emHeight               ( ) const,
  xHeight                ( ) const,
  externalLeading        ( ) const,
  nominalPointSize       ( ) const;
#endif

unsigned long
  pointSize              ( ) const;

/*---------------- Setting Information About the Dialog ------------------------
| These member functions allow customizing the dialog:                         |
|   setTitle          - Sets the font dialog's title.                          |
|   setPreviewText    - Sets the text to display in the font sample box.       |
|   setSizeList       - Sets the list of point size choices.  This only        |
|                       affects dialogs for vector fonts.  A dialog for a      |
|                       bit-map font will have the size list automatically     |
|                       set to the available sizes for the bit-map font.       |
|                       The size list is a comma delimited string              |
|                       (e.g. "8,10,12,14,18,24").                             |
|   setPosition       - Sets the initial placement of the dialog within the    |
|                       parent window.  If this is not set, the dialog is      |
|                       centered in the parent window.                         |
|   setDialogTemplate - Specifies a dialog template resource to be used in     |
|                       place of the OS/2-supplied default font dialog.        |
|   setDisplayPS      - Set a display presentation space, the IFontDialog      |
|                       will query the presentation space for candidate fonts. |
|   setPrinterPS      - Set a printer presentation space, the IFontDialog      |
|                       will query the presentation space for candidate fonts. |
|   setFamily         - Set the default font family.                           |
|   setPointSize      - Set the default font point size.                       |
|                                                                              |
------------------------------------------------------------------------------*/
#ifdef __OS2__
virtual  IVBFontDialog
 &setSizeList           ( const char*             sizeList        ),
 &setDisplayPS          ( const IPresSpaceHandle& presSpaceHandle ),
 &setPrinterPS          ( const IPresSpaceHandle& presSpaceHandle ),
 &setFamily             ( const char*             fontFamily      ),
 &setPointSize          ( unsigned long           pointSize       );
#endif

virtual  IVBFontDialog
 &setTitle              ( const char*             title           ),
 &setTitle              ( const IResourceId&      text            ),
 &setPreviewText        ( const char*             previewText     ),
 &setPosition           ( const IPoint&           position        ),
 &setDialogTemplate     ( const IResourceId&      templateId      );

/*----------------------- Access to Settings and Dialog ------------------------
| These member functions provide addressability to the IFontDialog and the     |
| Settings object (useful with tear-off attributes or access to methods not    |
| externalized by this class):                                                 |
|    fontDialog         - Returns a pointer to the IFontDialog object.         |
|    fontDialogSettings - Returns a pointer to the IFontDialog::Settings       |
|                        object.                                               |
|                                                                              |
------------------------------------------------------------------------------*/
IFontDialog
 *fontDialog         ( );
IFontDialog::Settings
 *fontDialogSettings ( );

/*----------------------- Notification Event Descriptions ----------------------
| These INotificationId strings are used for all notifications that            |
| IVBFontDialog provides to its observers:                                     |
|   createdId   - Notification identifier provided to observers when a new     |
|                 IFontDialog has been created.                                |
|   dismissedId - Notification identifier provided to observers when the       |
|                 showing IFontDialog has been dismissed.                      |
|   pressedOkId - Notification identifier provided to observers when the       |
|                 showing IFontDialog has been dismissed with ok button.       |
------------------------------------------------------------------------------*/
static INotificationId const
  IVB_IMPORT createdId,
  IVB_IMPORT dismissedId,
  IVB_IMPORT pressedOkId;

private:
/*------------------------------- PRIVATE ------------------------------------*/
class IDismissFontDialogDetector;

IWindow
 *fOwner;
IFontDialog::Settings
  fSettings;
IFont
  fFont;
IFontDialog
 *fFontDialog;
IDismissFontDialogDetector
 *fDismissHandler;
Boolean
  fShowing;
IVBFontDialogData
 *fFontDialogProxyData;

/*--------------------------- Blocked class methods ----------------------------
| Neither the copy constructor or assignment operator are supported.           |
|                                                                              |
------------------------------------------------------------------------------*/
  IVBFontDialog ( const IVBFontDialog& source );
IVBFontDialog
 &operator=        ( const IVBFontDialog& source );

/*--------------------- Report Detection of Dialog End -------------------------
| This member function provides a means to notify observers when a modeless    |
| IFontDialog is dismissed.                                                    |
|   dialogEndDetected - Notify observers of IFontDialog dismissal.             |
------------------------------------------------------------------------------*/
virtual IVBFontDialog
 &dialogEndDetected ( );


class  IDismissFontDialogDetector : public IFontDialogHandler
{
typedef IFontDialogHandler
  Inherited;
/*******************************************************************************
* The IDismissFontDialogDetector class detects the dismissal of a IFontDialog. *
*                                                                              *
********************************************************************************/
public:
/*------------------------ Constructors/Destructor -----------------------------
| You construct objects of this class:                                         |
|   -  From the default constructor which takes no objects.                    |
|                                                                              |
------------------------------------------------------------------------------*/
  IDismissFontDialogDetector( );

virtual
  ~IDismissFontDialogDetector( );

/*------------------------------ Dialog Dismissal ------------------------------
| This member function enables the capture of a IFontDialog dismissal event:   |
|   listenForResults  - Ready the capture of a IFontDialog dismissal event.    |
|                                                                              |
------------------------------------------------------------------------------*/
virtual IDismissFontDialogDetector
 &listenForResults ( IVBFontDialog* fontDialogProxy );

/*-------------------------------- Overrides -----------------------------------
| This member function is an overidde of an inherited function:                |
|   modelessResults -  Called when a modeless IFontDialog is dismissed.        |
|                                                                              |
------------------------------------------------------------------------------*/
virtual Boolean
  modelessResults  ( IFontDialog*      endingDialog );

private:
/*------------------------------- PRIVATE ------------------------------------*/

IVBFontDialog
 *fProxy;

};   // end IDismissFontDialogDetector

friend IDismissFontDialogDetector::modelessResults( IFontDialog* );

};  // end IVBFontDialog

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing and warning messages.                      */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* _IVBFONTD_ */
