#ifndef _IVBINFOA_
#define _IVBINFOA_
/*******************************************************************************
* FILE NAME: ivbinfoa.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IVBInfoArea                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <iinfoa.hpp>

#include <istring.hpp>

class IFrameWindow;
class IVBInfoAreaData;
class IResourceId;
class IModuleHandle;

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

#pragma pack(4)
#ifdef IC_PMWIN
#pragma info(nocls)
#endif

class IVBInfoArea : public IInfoArea {
typedef IInfoArea
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IVBInfoArea ( IFrameWindow*        frame,
                unsigned long        id = 0 );

  IVBInfoArea ( IFrameWindow*        frame,
                unsigned long        id,
                const char*          resDLLName );

  IVBInfoArea ( IFrameWindow*        frame,
                const IModuleHandle& resMod,
                unsigned long        id = 0 );

  IVBInfoArea ( IFrameWindow*        frame,
                const char*          resDLLName,
                unsigned long        id = 0 );

virtual
 ~IVBInfoArea ( );


/*----------------------- Dynamically Updating Help Text ---------------------*/
virtual IVBInfoArea
 &setHelpText           ( unsigned long      menuId,
                          const IString&     text    ),

 &setHelpText           ( unsigned long      menuId,
                          const IResourceId& text    ),

 &removeHelpText        ( unsigned long      menuId  );

virtual IString
  helpText              ( unsigned long      menuId  ) const;


protected:
/*---------------------- Information String Processing -----------------------*/
virtual IString
  informationFor        ( unsigned long menuId ) const;


private:
/*--------------------------------- Private ----------------------------------*/
IVBInfoAreaData
  *fVBInfoAreaData;

}; // IVBInfoArea

#ifdef IC_PMWIN
#pragma info(restore)
#endif
#pragma pack()

#endif // _IVBINFOA_
