#ifndef _IVBLONG_
  #define _IVBLONG_
/*******************************************************************************
* FILE NAME: ivblong.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBLongPart - IBM VB sample Long part.                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBDTYPE_
  #include <ivbdtype.hpp>
#endif

#ifndef __limits_h
  #include <limits.h>
#endif

#ifndef _ISTRING_
  #include <istring.hpp>
#endif


/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03.LIB")
    #endif
  #endif
#endif


/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBLongPart : public IVBDataTypePart
{
typedef IVBDataTypePart
  Inherited;
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------- Constructors/Destructor ----------------------------
------------------------------------------------------------------------------*/
  IVBLongPart (long value = 0);
  IVBLongPart (const IVBLongPart& partCopy);
virtual
  ~IVBLongPart ();

/*-------------------------------- Operators -----------------------------------
|   operator ==       - Operator == (return true if equal).                    |
|   operator !=       - Operator != (return true if not equal).                |
------------------------------------------------------------------------------*/
  IVBLongPart& operator= (const IVBLongPart& aIVBLongPart);
Boolean
  operator == (const IVBLongPart& aValue) const,
  operator != (const IVBLongPart& aValue) const,
  operator == (const IVBLongPart* aValue) const,
  operator != (const IVBLongPart* aValue) const;

virtual IString
  asString    ( ) const;

/*-------------------------------- Attributes ----------------------------------
| List of query and set members functions for this class:                      |
|                                                                              |
|   value             - Query the value (long) attribute.                      |
|   valueAsText       - Query the valueAsText (IString) attribute.             |
|   valueAs1Based     - Query the valueAs1Based (long) attribute.              |
|   defaultValue      - Query the defaultValue (long) attribute.               |
|   isValueEqualDefault - Query the valueEqualDefault (Boolean) attribute.     |
|   isValueNotEqualDefault - Query the valueNotEqualDefault (Boolean) attribute. |
|   lowLimit          - Query the lowLimit (long) attribute.                   |
|   highLimit         - Query the highLimit (long) attribute.                  |
|   isValueEqualLowLimit - Query the valueEqualLowLimit (Boolean) attribute.   |
|   isValueEqualHighLimit - Query the valueEqualHighLimit (Boolean) attribute. |
|   isValueBelowLowLimit - Query the valueBelowLowLimit (Boolean) attribute.   |
|   isValueAboveHighLimit - Query the valueAboveHighLimit (Boolean) attribute. |
|   isValueOutsideLimits - Query the valueOutsideLimits (Boolean) attribute.   |
|   isValueWithinLimits - Query the valueWithinLimits (Boolean) attribute.     |
|   isValueNotZero    - Query the valueNotZero (Boolean) attribute.            |
|   isValueZero       - Query the valueZero (Boolean) attribute.               |
|   isValuePositive   - Query the valuePositive (Boolean) attribute.           |
|   isValueNegative   - Query the valueNegative (Boolean) attribute.           |
|   setValue          - Set the value (long) attribute.                        |
|   setValueAsText    - Set the valueAsText (IString) attribute.               |
|   setValueAs1Based  - Set the valueAs1Based (long) attribute.                |
|   setDefaultValue   - Set the defaultValue (long) attribute.                 |
|   setLowLimit       - Set the lowLimit (long) attribute.                     |
|   setHighLimit      - Set the highLimit (long) attribute.                    |
------------------------------------------------------------------------------*/

virtual long
  value () const;
virtual IVBLongPart
 &setValue (long aValue),
 &setValue ();

virtual IString
  valueAsText () const;
virtual IVBLongPart
 &setValueAsText (const IString& valueAsText),
 &setValueAsText (const IString* valueAsText);

virtual long
  valueAs1Based () const;
virtual IVBLongPart
 &setValueAs1Based (long valueAs1Based);

virtual long
  defaultValue () const;
virtual IVBLongPart
 &setDefaultValue (long defaultValue = 0);

virtual Boolean
  isValueEqualDefault () const;

virtual Boolean
  isValueNotEqualDefault () const;

virtual long
  lowLimit () const;
virtual IVBLongPart
 &setLowLimit (long aLowLimit = LONG_MIN);

virtual long
  highLimit () const;
virtual IVBLongPart
 &setHighLimit (long highLimit = LONG_MAX);

virtual Boolean
  isValueEqualLowLimit () const;

virtual Boolean
  isValueEqualHighLimit () const;

virtual Boolean
  isValueBelowLowLimit () const;

virtual Boolean
  isValueAboveHighLimit () const;

virtual Boolean
  isValueOutsideLimits () const;

virtual Boolean
  isValueWithinLimits () const;

virtual Boolean
  isValueNotZero () const;

virtual Boolean
  isValueZero () const;

virtual Boolean
  isValuePositive () const;

virtual Boolean
  isValueNegative () const;

/*-------------------------------- Actions -------------------------------------
| List of operations or services provided by this class:                       |
|                                                                              |
|   assignValueToZero               - Assign value attribute to 0 (false). |
|   assignValueToOne                - Assign value attribute to 1 (true).      |
|   assignValueToLowLimit           - Assign value attribute to low limit. |
|   assignValueToHighLimit          - Assign value attribute to high limit |
|   assignValueToDefault            - Assign the value attribute to false. |
|   assignValueToRandom             - Assign value to pseudo-random number |
|   copyValueToDefault              - Copy value to default value.             |
|   squareValue                     - Square the value attribute.              |
|   andValue                        - Perform and operator on value.           |
|   orValue                         - Perform or operator on value.            |
|   addValue                        - Perform add operator on value.           |
|   subractValue                    - Perform subract operator on value.       |
|   divideValue                     - Perform divide operator on value.        |
|   multiplyValue                   - Perform multiply operator on value.      |
------------------------------------------------------------------------------*/

virtual IVBLongPart
 &assignValueToZero (),
 &assignValueToOne (),
 &assignValueToLowLimit (),
 &assignValueToHighLimit (),
 &assignValueToDefault (),
 &assignValueToRandom (),
 &copyValueToDefault (),
 &squareValue (),
 &andValue (long andValue = 1),
 &orValue (long orValue = 1),
 &addValue (long addValue = 1),
 &subtractValue (long subtractValue = 1),
 &multiplyValue (long multiplyValue = 2),
 &divideValue (long divideValue = 2);

/*----------------------- Notification Event Descriptions ----------------------
| List of attribute and event notification identifiers:                        |
|                                                                              |
------------------------------------------------------------------------------*/


private:
/*--------------------------- PRIVATE ----------------------------------------*/
  long iValue;                          //Data member for value attribute
  long iDefaultValue;                   //Data member for defaultValue attribute
  long iLowLimit;                       //Data member for lowLimit attribute
  long iHighLimit;                      //Data member for highLimit attribute
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
