#ifndef _IVBLOR_
  #define _IVBLOR_
/*******************************************************************************
* FILE NAME: ivblor.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBLogicalOrPart - VB Logical Or Part.                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/
#ifndef _IVBDEFS__
#include <ivbdefs.h>
#endif

#ifndef _IVBDTYPE_
  #include <ivbdtype.hpp>
#endif

#ifndef _ISTRING_
  #include <istring.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03.LIB")
    #endif
  #endif
#endif

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBLogicalOrPart : public IVBDataTypePart
{
typedef IVBDataTypePart
  Inherited;
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------- Constructors/Destructor ----------------------------
------------------------------------------------------------------------------*/
  IVBLogicalOrPart ();
  IVBLogicalOrPart (const IVBLogicalOrPart& partCopy);
virtual
  ~IVBLogicalOrPart ();

/*-------------------------------- Operators -----------------------------------
|   operator ==       - Operator == (return true if equal).                    |
|   operator !=       - Operator != (return true if not equal).                |
------------------------------------------------------------------------------*/
  IVBLogicalOrPart& operator= (const IVBLogicalOrPart& aIVBLogicalOrPart);
Boolean
  operator == (const IVBLogicalOrPart& aValue) const,
  operator != (const IVBLogicalOrPart& aValue) const,
  operator == (const IVBLogicalOrPart* aValue) const,
  operator != (const IVBLogicalOrPart* aValue) const;

virtual IString
  asString    ( ) const;

/*-------------------------------- Attributes ----------------------------------
| List of query and set members functions for this class:                      |
|                                                                              |
|   value             - Query the value (Boolean) attribute.                   |
|   notValue          - Query the notValue (Boolean) attribute.                |
|   valueAsText       - Query the valueAsText (IString) attribute.             |
|   input1            - Query the input1 (Boolean) attribute.                  |
|   input2            - Query the input2 (Boolean) attribute.                  |
|   input3            - Query the input3 (Boolean) attribute.                  |
|   input4            - Query the input4 (Boolean) attribute.                  |
|   input5            - Query the input5 (Boolean) attribute.                  |
|   input6            - Query the input6 (Boolean) attribute.                  |
|   input7            - Query the input7 (Boolean) attribute.                  |
|   input8            - Query the input8 (Boolean) attribute.                  |
|   input9            - Query the input9 (Boolean) attribute.                  |
|   input10           - Query the input10 (Boolean) attribute.                 |
|   notInput1         - Query the notInput1 (Boolean) attribute.               |
|   notInput2         - Query the notInput2 (Boolean) attribute.               |
|   notInput3         - Query the notInput3 (Boolean) attribute.               |
|   notInput4         - Query the notInput4 (Boolean) attribute.               |
|   notInput5         - Query the notInput5 (Boolean) attribute.               |
|   notInput6         - Query the notInput6 (Boolean) attribute.               |
|   notInput7         - Query the notInput7 (Boolean) attribute.               |
|   notInput8         - Query the notInput8 (Boolean) attribute.               |
|   notInput9         - Query the notInput9 (Boolean) attribute.               |
|   notInput10        - Query the notInput10 (Boolean) attribute.              |
|   defaultInput      - Query the defaultInput (Boolean) attribute.             |
|   setInput1         - Set the input1 (Boolean) attribute.                    |
|   setInput2         - Set the input2 (Boolean) attribute.                    |
|   setInput3         - Set the input3 (Boolean) attribute.                    |
|   setInput4         - Set the input4 (Boolean) attribute.                    |
|   setInput5         - Set the input5 (Boolean) attribute.                    |
|   setInput6         - Set the input6 (Boolean) attribute.                    |
|   setInput7         - Set the input7 (Boolean) attribute.                    |
|   setInput8         - Set the input8 (Boolean) attribute.                    |
|   setInput9         - Set the input9 (Boolean) attribute.                    |
|   setInput10        - Set the input10 (Boolean) attribute.                   |
|   setNotInput1      - Set the notInput1 (Boolean) attribute.                 |
|   setNotInput2      - Set the notInput2 (Boolean) attribute.                 |
|   setNotInput3      - Set the notInput3 (Boolean) attribute.                 |
|   setNotInput4      - Set the notInput4 (Boolean) attribute.                 |
|   setNotInput5      - Set the notInput5 (Boolean) attribute.                 |
|   setNotInput6      - Set the notInput6 (Boolean) attribute.                 |
|   setNotInput7      - Set the notInput7 (Boolean) attribute.                 |
|   setNotInput8      - Set the notInput8 (Boolean) attribute.                 |
|   setNotInput9      - Set the notInput9 (Boolean) attribute.                 |
|   setNotInput10     - Set the notInput10 (Boolean) attribute.                |
------------------------------------------------------------------------------*/

virtual Boolean
  value () const;

virtual Boolean
  notValue () const;

virtual IString
  valueAsText () const;

virtual Boolean
  input1 () const;
virtual IVBLogicalOrPart
 &setInput1 (Boolean input1),
 &setInput1 ();

virtual Boolean
  input2 () const;
virtual IVBLogicalOrPart
 &setInput2 (Boolean input2),
 &setInput2 ();

virtual Boolean
  input3 () const;
virtual IVBLogicalOrPart
 &setInput3 (Boolean input3),
 &setInput3 ();

virtual Boolean
  input4 () const;
virtual IVBLogicalOrPart
 &setInput4 (Boolean input4),
 &setInput4 ();

virtual Boolean
  input5 () const;
virtual IVBLogicalOrPart
 &setInput5 (Boolean input5),
 &setInput5 ();

virtual Boolean
  input6 () const;
virtual IVBLogicalOrPart
 &setInput6 (Boolean input6),
 &setInput6 ();

virtual Boolean
  input7 () const;
virtual IVBLogicalOrPart
 &setInput7 (Boolean input7),
 &setInput7 ();

virtual Boolean
  input8 () const;
virtual IVBLogicalOrPart
 &setInput8 (Boolean input8),
 &setInput8 ();

virtual Boolean
  input9 () const;
virtual IVBLogicalOrPart
 &setInput9 (Boolean input9),
 &setInput9 ();

virtual Boolean
  input10 () const;
virtual IVBLogicalOrPart
 &setInput10 (Boolean input10),
 &setInput10 ();

virtual Boolean
  notInput1 () const;
virtual IVBLogicalOrPart
 &setNotInput1 (Boolean notInput1),
 &setNotInput1 ();

virtual Boolean
  notInput2 () const;
virtual IVBLogicalOrPart
 &setNotInput2 (Boolean notInput2),
 &setNotInput2 ();

virtual Boolean
  notInput3 () const;
virtual IVBLogicalOrPart
 &setNotInput3 (Boolean notInput3),
 &setNotInput3 ();

virtual Boolean
  notInput4 () const;
virtual IVBLogicalOrPart
 &setNotInput4 (Boolean notInput4),
 &setNotInput4 ();

virtual Boolean
  notInput5 () const;
virtual IVBLogicalOrPart
 &setNotInput5 (Boolean notInput5),
 &setNotInput5 ();

virtual Boolean
  notInput6 () const;
virtual IVBLogicalOrPart
 &setNotInput6 (Boolean notInput6),
 &setNotInput6 ();

virtual Boolean
  notInput7 () const;
virtual IVBLogicalOrPart
 &setNotInput7 (Boolean notInput7),
 &setNotInput7 ();

virtual Boolean
  notInput8 () const;
virtual IVBLogicalOrPart
 &setNotInput8 (Boolean notInput8),
 &setNotInput8 ();

virtual Boolean
  notInput9 () const;
virtual IVBLogicalOrPart
 &setNotInput9 (Boolean notInput9),
 &setNotInput9 ();

virtual Boolean
  notInput10 () const;
virtual IVBLogicalOrPart
 &setNotInput10 (Boolean notInput10),
 &setNotInput10 ();

virtual Boolean
  defaultInput () const;

/*-------------------------------- Actions -------------------------------------
| List of operations or services provided by this class:                       |
|                                                                              |
------------------------------------------------------------------------------*/



/*----------------------- Notification Event Descriptions ----------------------
| List of attribute and event notification identifiers:                        |
|                                                                              |
|   valueId           - Notification ID provided to observers when the         |
|                       value attribute changes.                               |
|   input1Id          - Notification ID provided to observers when the         |
|                       input1 attribute changes.                              |
|   input2Id          - Notification ID provided to observers when the         |
|                       input2 attribute changes.                              |
|   input3Id          - Notification ID provided to observers when the         |
|                       input3 attribute changes.                              |
|   input4Id          - Notification ID provided to observers when the         |
|                       input4 attribute changes.                              |
|   input5Id          - Notification ID provided to observers when the         |
|                       input5 attribute changes.                              |
|   input6Id          - Notification ID provided to observers when the         |
|                       input6 attribute changes.                              |
|   input7Id          - Notification ID provided to observers when the         |
|                       input7 attribute changes.                              |
|   input8Id          - Notification ID provided to observers when the         |
|                       input8 attribute changes.                              |
|   input9Id          - Notification ID provided to observers when the         |
|                       input9 attribute changes.                              |
|   input10Id         - Notification ID provided to observers when the         |
|                       input10 attribute changes.                             |
------------------------------------------------------------------------------*/
static INotificationId const
  IVB_IMPORT valueId,
  IVB_IMPORT input1Id,
  IVB_IMPORT input2Id,
  IVB_IMPORT input3Id,
  IVB_IMPORT input4Id,
  IVB_IMPORT input5Id,
  IVB_IMPORT input6Id,
  IVB_IMPORT input7Id,
  IVB_IMPORT input8Id,
  IVB_IMPORT input9Id,
  IVB_IMPORT input10Id;


protected:
/*-------------------------------- Protected Services --------------------------
| List of protected operations or services provided by this class:             |
|                                                                              |
|   compute           - compute action.                                        |
------------------------------------------------------------------------------*/
virtual IVBLogicalOrPart
  &compute ();

private:
/*--------------------------- PRIVATE ----------------------------------------*/
  Boolean iValue;                       //Data member for value attribute
  Boolean iInput1;                      //Data member for input1 attribute
  Boolean iInput2;                      //Data member for input2 attribute
  Boolean iInput3;                      //Data member for input3 attribute
  Boolean iInput4;                      //Data member for input4 attribute
  Boolean iInput5;                      //Data member for input5 attribute
  Boolean iInput6;                      //Data member for input6 attribute
  Boolean iInput7;                      //Data member for input7 attribute
  Boolean iInput8;                      //Data member for input8 attribute
  Boolean iInput9;                      //Data member for input9 attribute
  Boolean iInput10;                     //Data member for input10 attribute
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
