#ifndef _IVBMENUH_
  #define _IVBMENUH_

/*******************************************************************************
* FILE NAME: ivbmenuh.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBPopupMenuHandler - Popup Menu Handler                                  *
*    IVBCnrPopupMenuHandler - Cnr Popup Menu Handler                           *
*    IVBCheckMenuHandler - Auto Check Menu Item Handler                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
*******************************************************************************/

#ifndef _IMENUHDR_
  #include <imenuhdr.hpp>
#endif

#ifndef _ICNRMHDR_
  #include <icnrmhdr.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

class IPopUpMenu;
class IMenu;

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

//**************************************************************************
// Class:   IVBPopupMenuHandler                                            *
//                                                                         *
// Purpose: Subclass of IMenuHandler so that the a PopUp Menu can be       *
//          created.                                                       *
//                                                                         *
//**************************************************************************
class IVBPopupMenuHandler: public IMenuHandler
{
public:
  IVBPopupMenuHandler (IPopUpMenu * aPopupMenu);

virtual
  ~IVBPopupMenuHandler ();

protected:
  Boolean makePopUpMenu(IMenuEvent& menuEvent);

IPopUpMenu * iPopup;

};

//**************************************************************************
// Class:   IVBCnrPopupMenuHandler                                         *
//                                                                         *
// Purpose: Subclass of ICnrMenuHandler so that the a PopUp Menu can be    *
//          created.                                                       *
//                                                                         *
//**************************************************************************
class IVBCnrPopupMenuHandler: public ICnrMenuHandler
{
public:
  IVBCnrPopupMenuHandler (IPopUpMenu * aPopupMenu);

virtual
  ~IVBCnrPopupMenuHandler ();

protected:
  Boolean makePopUpMenu(IMenuEvent& menuEvent);

IPopUpMenu * iPopup;

};

//**************************************************************************
// Class:   IVBCheckMenuHandler                                            *
//                                                                         *
// Purpose: Subclass of IMenuHandler so that the a Menu Item can be        *
//          auto checked.                                                  *
//                                                                         *
//**************************************************************************
class IVBCheckMenuHandler : public IMenuHandler
{
public:
  IVBCheckMenuHandler (IMenu * target, unsigned long aMenuId);

virtual
  ~IVBCheckMenuHandler ();

virtual Boolean
  menuSelected  ( IMenuEvent& menuEvent );

protected:
  unsigned long iMenuId;
  IMenu * iTarget;
} ;

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
