#ifndef _IVBNBKPG_
  #define _IVBNBKPG_
/*******************************************************************************
* FILE NAME: ivbnbkpg.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBNotebookPage - IBM Visual Builder Notebook Page part.                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
*******************************************************************************/

#ifndef _ISTDNTFY_
  #include <istdntfy.hpp>
#endif

#ifndef _INOTEBK_
  #include <inotebk.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

//*************************************************************
// Class definition for IVBNotebookPage
//*************************************************************
class IVBNotebookPage : public IStandardNotifier {
public:

//*************************************************************
// Constructors / destructors
//*************************************************************
  IVBNotebookPage (INotebook * parent,
                   const INotebook::PageSettings::Attribute & attribute,
                   IWindow * pageWindow = 0);
virtual
 ~IVBNotebookPage();

virtual IVBNotebookPage
 &setStatusText   (const char* statusText),
 &setStatusText   (const IResourceId&   resourceId),
 &setTabText      (const char* tabText),
 &setTabText      (const IResourceId& resourceId),
 &setTabBitmap    (const IBitmapHandle& bitmap),
 &setTabBitmap    (const IResourceId& resourceId),
 &setWindow       (IWindow* window = 0);

virtual IString
  statusText      () const,
  tabText         () const;

virtual IBitmapHandle
  tabBitmap       () const;

virtual IWindow
 *window          () const;

virtual const IWindow
 *notebook        () const;

virtual IPageHandle
   pageHandle     () const;

private:
//*************************************************************
// private member data
//*************************************************************
INotebook * parentNB;
IPageHandle pgHandle;
};   //IVBNotebookPage

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
