#ifndef _IVBSTRNG_
  #define _IVBSTRNG_
/*******************************************************************************
* FILE NAME: ivbstrng.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBStringPart - IBM VB sample string part.                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBDTYPE_
  #include <ivbdtype.hpp>
#endif

#ifndef _ISTRING_
  #include <istring.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03.LIB")
    #endif
  #endif
#endif


/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBStringPart : public IVBDataTypePart
{
typedef IVBDataTypePart
  Inherited;
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------- Constructors/Destructor ----------------------------
------------------------------------------------------------------------------*/
  IVBStringPart (const IString& text = IString());
  IVBStringPart (const IVBStringPart& partCopy);
virtual
  ~IVBStringPart ();

/*-------------------------------- Operators -----------------------------------
|   operator ==       - Operator == (return true if equal).                    |
|   operator !=       - Operator != (return true if not equal).                |
------------------------------------------------------------------------------*/
  IVBStringPart& operator= (const IVBStringPart& aIVBStringPart);
Boolean
  operator == (const IVBStringPart& aValue) const,
  operator != (const IVBStringPart& aValue) const,
  operator == (const IVBStringPart* aValue) const,
  operator != (const IVBStringPart* aValue) const;

#ifdef __OS2__
virtual IString
  asString    ( ) const;
#endif

/*-------------------------------- Attributes ----------------------------------
| List of query and set members functions for this class:                      |
|                                                                              |
|   text              - Query the text (IString) attribute.                    |
|   textAsLowerCase   - Query the textAsLowerCase (IString) attribute.         |
|   textAsUpperCase   - Query the textAsUpperCase (IString) attribute.         |
|   defaultText       - Query the defaultText (IString) attribute.             |
|   isTextEqualDefault - Query the textEqualDefault (Boolean) attribute.       |
|   isTextNotEqualDefault - Query the textNotEqualDefault (Boolean) attribute. |
|   textLength        - Query the textLength (unsigned long) attribute.             |
|   isLowerCase       - Query the lowerCase (Boolean) attribute.               |
|   isUpperCase       - Query the upperCase (Boolean) attribute.               |
|   isDigits          - Query the digits (Boolean) attribute.                  |
|   setText           - Set the text (IString) attribute.                      |
|   setDefaultText    - Set the defaultText (IString) attribute.               |
------------------------------------------------------------------------------*/

virtual IString
  text () const;
virtual IVBStringPart
 &setText (const IString& text),
 &setText ();

virtual IString
  textAsLowerCase () const;

virtual IString
  textAsUpperCase () const;

virtual IString
  defaultText () const;
virtual IVBStringPart
 &setDefaultText (const IString& defaultText = false);

virtual Boolean
  isTextEqualDefault () const;

virtual Boolean
  isTextNotEqualDefault () const;

virtual unsigned long
  textLength () const;

virtual Boolean
  isLowerCase () const;

virtual Boolean
  isUpperCase () const;

virtual Boolean
  isDigits () const;

/*-------------------------------- Actions -------------------------------------
| List of operations or services provided by this class:                       |
|                                                                              |
|   assignTextToEmpty               - Assign text attribute to empty.          |
|   assignTextToDateToday           - Assign text to today's date.             |
|   assignTextToTimeNow             - Assign text to time now.                 |
|   assignTextToCmdLineParm0           - Set text to command line parm 0. |
|   assignTextToCmdLineParm1           - Set text to command line parm 1. |
|   assignTextToDefault             - Assign the text attribute to false. |
|   changeTextToLowerCase           - Change the text to lower case.           |
|   changeTextToUpperCase           - Change the text to upper case.           |
|   reverseText                     - Perform reverse on text.                 |
|   stripBlanksOnText               - Strip blanks on text.                    |
|   appendText                      - Append to the end of text.               |
|   preappendText                   - Add to the beginning of text.            |
------------------------------------------------------------------------------*/

virtual IVBStringPart
 &assignTextToEmpty (),
 &assignTextToDateToday (),
 &assignTextToTimeNow (),
 &assignTextToCmdLineParm0 (),
 &assignTextToCmdLineParm1 (),
 &assignTextToDefault (),
 &changeTextToLowerCase (),
 &changeTextToUpperCase (),
 &reverseText (),
 &stripBlanksOnText (),
 &appendText (const IString& appendText),
 &preappendText (const IString& appendText);

/*----------------------- Notification Event Descriptions ----------------------
| List of attribute and event notification identifiers:                        |
|                                                                              |
------------------------------------------------------------------------------*/


private:
/*--------------------------- PRIVATE ----------------------------------------*/
  IString iText;                        //Data member for text attribute
  IString iDefaultText;                 //Data member for defaultText attribute
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
