#ifndef _IVBUSHRT_
  #define _IVBUSHRT_
/*******************************************************************************
* FILE NAME: ivbushrt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*    IVBUnsignedShortPart - IBM VB sample Unsigned Short part.                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBDTYPE_
  #include <ivbdtype.hpp>
#endif

#ifndef __limits_h
  #include <limits.h>
#endif

#ifndef _ISTRING_
  #include <istring.hpp>
#endif


/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03.LIB")
    #endif
  #endif
#endif


/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBUnsignedShortPart : public IVBDataTypePart
{
typedef IVBDataTypePart
  Inherited;
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------- Constructors -------------------------------------*/
  IVBUnsignedShortPart ( unsigned short value = 0 );
  IVBUnsignedShortPart ( const IVBUnsignedShortPart& partCopy );
virtual
 ~IVBUnsignedShortPart ( );

/*-------------------------------- Operators -----------------------------------
|   operator ==       - Operator == (return true if equal).                    |
|   operator !=       - Operator != (return true if not equal).                |
------------------------------------------------------------------------------*/
IVBUnsignedShortPart
 &operator=   ( const IVBUnsignedShortPart& aIVBUnsignedShortPart );
Boolean
  operator == ( const IVBUnsignedShortPart& aValue ) const,
  operator != ( const IVBUnsignedShortPart& aValue ) const,
  operator == ( const IVBUnsignedShortPart* aValue ) const,
  operator != ( const IVBUnsignedShortPart* aValue ) const;

virtual IString
  asString    ( ) const;

/*-------------------------------- Attributes ----------------------------------
| List of query and set members functions for this class:                      |
|                                                                              |
|   value             - Query the value (unsigned short) attribute.             |
|   valueAsText       - Query the valueAsText (IString) attribute.             |
|   valueAs1Based     - Query the valueAs1Based (unsigned short) attribute.             |
|   defaultValue      - Query the defaultValue (unsigned short) attribute.             |
|   isValueEqualDefault - Query the valueEqualDefault (Boolean) attribute.     |
|   isValueNotEqualDefault - Query the valueNotEqualDefault (Boolean) attribute. |
|   lowLimit          - Query the lowLimit (unsigned short) attribute.             |
|   highLimit         - Query the highLimit (unsigned short) attribute.             |
|   isValueEqualLowLimit - Query the valueEqualLowLimit (Boolean) attribute.   |
|   isValueEqualHighLimit - Query the valueEqualHighLimit (Boolean) attribute. |
|   isValueBelowLowLimit - Query the valueBelowLowLimit (Boolean) attribute.   |
|   isValueAboveHighLimit - Query the valueAboveHighLimit (Boolean) attribute. |
|   isValueOutsideLimits - Query the valueOutsideLimits (Boolean) attribute.   |
|   isValueWithinLimits - Query the valueWithinLimits (Boolean) attribute.     |
|   isValueNotZero    - Query the valueNotZero (Boolean) attribute.            |
|   isValueZero       - Query the valueZero (Boolean) attribute.               |
|   setValue          - Set the value (unsigned short) attribute.               |
|   setValueAsText    - Set the valueAsText (IString) attribute.               |
|   setValueAs1Based  - Set the valueAs1Based (unsigned short) attribute.      |
|   setDefaultValue   - Set the defaultValue (unsigned short) attribute.       |
|   setLowLimit       - Set the lowLimit (unsigned short) attribute.               |
|   setHighLimit      - Set the highLimit (unsigned short) attribute.          |
------------------------------------------------------------------------------*/

virtual unsigned short
  value                  ( ) const;
virtual IVBUnsignedShortPart
 &setValue               ( unsigned short aValue ),
 &setValue               ( );

virtual IString
  valueAsText            ( ) const;
virtual IVBUnsignedShortPart
 &setValueAsText         ( const IString& valueAsText ),
 &setValueAsText         ( const IString* valueAsText );

virtual unsigned short
  valueAs1Based          ( ) const;
virtual IVBUnsignedShortPart
 &setValueAs1Based       ( unsigned short valueAs1Based );

virtual unsigned short
  defaultValue           ( ) const;
virtual IVBUnsignedShortPart
 &setDefaultValue        ( unsigned short defaultValue = 0 );

virtual Boolean
  isValueEqualDefault    ( ) const;

virtual Boolean
  isValueNotEqualDefault ( ) const;

virtual unsigned short
  lowLimit               ( ) const;
virtual IVBUnsignedShortPart
 &setLowLimit            ( unsigned short aLowLimit = 0 );

virtual unsigned short
  highLimit              ( ) const;
virtual IVBUnsignedShortPart
 &setHighLimit           ( unsigned short highLimit = USHRT_MAX );

virtual Boolean
  isValueEqualLowLimit   ( ) const;

virtual Boolean
  isValueEqualHighLimit  ( ) const;

virtual Boolean
  isValueBelowLowLimit   ( ) const;

virtual Boolean
  isValueAboveHighLimit  ( ) const;

virtual Boolean
  isValueOutsideLimits   ( ) const;

virtual Boolean
  isValueWithinLimits    ( ) const;

virtual Boolean
  isValueNotZero         ( ) const;

virtual Boolean
  isValueZero            ( ) const;

/*-------------------------------- Actions -------------------------------------
| List of operations or services provided by this class:                       |
|                                                                              |
|   assignValueToZero               - Assign value attribute to 0 (false). |
|   assignValueToOne                - Assign value attribute to 1 (true).      |
|   assignValueToLowLimit           - Assign value attribute to low limit. |
|   assignValueToHighLimit          - Assign value attribute to high limit |
|   assignValueToDefault            - Assign the value attribute to false. |
|   assignValueToRandom             - Assign value to pseudo-random number |
|   copyValueToDefault              - Copy value to default value.             |
|   squareValue                     - Square the value attribute.              |
|   andValue                        - Perform and operator on value.           |
|   orValue                         - Perform or operator on value.            |
|   addValue                        - Perform add operator on value.           |
|   subractValue                    - Perform subract operator on value.       |
|   divideValue                     - Perform divide operator on value.        |
|   multiplyValue                   - Perform multiply operator on value.      |
------------------------------------------------------------------------------*/

virtual IVBUnsignedShortPart
 &assignValueToZero      ( ),
 &assignValueToOne       ( ),
 &assignValueToLowLimit  ( ),
 &assignValueToHighLimit ( ),
 &assignValueToDefault   ( ),
 &assignValueToRandom    ( ),
 &copyValueToDefault     ( ),
 &squareValue            ( ),
 &andValue               ( unsigned short andValue      = 1 ),
 &orValue                ( unsigned short orValue       = 1 ),
 &addValue               ( unsigned short addValue      = 1 ),
 &subtractValue          ( unsigned short subtractValue = 1 ),
 &multiplyValue          ( unsigned short multiplyValue = 2 ),
 &divideValue            ( unsigned short divideValue   = 2 );

/*----------------------- Notification Event Descriptions ----------------------
| List of attribute and event notification identifiers:                        |
|                                                                              |
------------------------------------------------------------------------------*/


private:
/*--------------------------- PRIVATE ----------------------------------------*/
  unsigned short iValue;                //Data member for value attribute
  unsigned short iDefaultValue;         //Data member for defaultValue attribute
  unsigned short iLowLimit;             //Data member for lowLimit attribute
  unsigned short iHighLimit;            //Data member for highLimit attribute
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
