/*******************************************************************************
* FILE NAME: ivbvcls.c                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBVariableClass - Variable template class for classes.                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*******************************************************************************/

#ifndef _IVBVCLS_
  #include <ivbvcls.h>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif

#include <ivbdefs.h>

/*------------------------------------------------------------------------------
| IVBVariableClass <Element>::IVBVariableClass                                 |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariableClass <Element>::IVBVariableClass ()
  : IVBVariableClassBase ()
{
}

/*------------------------------------------------------------------------------
| IVBVariableClass <Element>::~IVBVariableClass                                |
|                                                                              |
| Standard destructor.                                                         |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariableClass <Element>::~IVBVariableClass ()
{
}

/*------------------------------------------------------------------------------
| IVBVariableClass <Element>::target                                             |
|                                                                              |
| Returns the target attribute.                                                |
------------------------------------------------------------------------------*/
template < class Element >
Element& IVBVariableClass <Element>::target ()
{
  return iTarget;
}

/*------------------------------------------------------------------------------
| IVBVariableClass <Element>::targetPtr                                        |
|                                                                              |
| Returns the target attribute.                                                |
------------------------------------------------------------------------------*/
template < class Element >
Element* IVBVariableClass <Element>::targetPtr ()
{
  return &iTarget;
}

/*------------------------------------------------------------------------------
| IVBVariableClass <Element>::setTarget                                          |
|                                                                              |
| Sets the target attribute.                                                   |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariableClass <Element>& IVBVariableClass <Element>::setTarget
  (Element newTarget)
{
  iTarget = newTarget;
  notifyObservers(INotificationEvent(VBINITIALIZEID, *this));
  notifyObservers(INotificationEvent(targetId, *this));
  return *this;
}

/*------------------------------------------------------------------------------
| IVBVariableClass <Element>::setTarget                                          |
|                                                                              |
| Sets the target attribute.                                                   |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariableClass <Element>& IVBVariableClass <Element>::setTarget
  (Element* newTarget)
{
  return setTarget(*newTarget);
}
