/*******************************************************************************
* FILE NAME: ivbvclsp.c                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBVariableClassPointer - Variable template class for classes.            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*******************************************************************************/

#ifndef _IVBVCLSP_
  #include <ivbvclsp.h>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif

#include <ivbdefs.h>

/*------------------------------------------------------------------------------
| IVBVariableClassPointer <Element>::IVBVariableClassPointer                   |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariableClassPointer <Element>::IVBVariableClassPointer ()
  : IVBVariableClassBase (), iTarget (0)
{
}

/*------------------------------------------------------------------------------
| IVBVariableClassPointer <Element>::~IVBVariableClassPointer                  |
|                                                                              |
| Standard destructor.                                                         |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariableClassPointer <Element>::~IVBVariableClassPointer ()
{
  if (iAutoDeleteTarget) {
    delete iTarget;
  } /* endif */
}

/*------------------------------------------------------------------------------
| IVBVariableClassPointer <Element>::target                                    |
|                                                                              |
| Returns the target attribute.                                                |
------------------------------------------------------------------------------*/
template < class Element >
Element IVBVariableClassPointer <Element>::target () const
{
  return iTarget;
}

/*------------------------------------------------------------------------------
| IVBVariableClassPointer <Element>::targetPtr                                 |
|                                                                              |
| Returns the target attribute.                                                |
------------------------------------------------------------------------------*/
template < class Element >
Element IVBVariableClassPointer <Element>::targetPtr () const
{
  return iTarget;
}

/*------------------------------------------------------------------------------
| IVBVariableClassPointer <Element>::setTarget                                 |
|                                                                              |
| Sets the target attribute.                                                   |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariableClassPointer <Element>&
  IVBVariableClassPointer <Element>::setTarget (Element newTarget)
{
  if (iTarget != newTarget)
  {
    if (iAutoDeleteTarget) {
      delete iTarget;
    } /* endif */
    iTarget = newTarget;
  } /* endif */
  notifyObservers(INotificationEvent(VBINITIALIZEID, *this));
  notifyObservers(INotificationEvent(targetId, *this));
  return *this;
}

/*------------------------------------------------------------------------------
| IVBVariableClassPointer <Element>::deleteTarget                              |
|                                                                              |
| Delete the target attribute.                                                 |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariableClassPointer <Element>&
  IVBVariableClassPointer <Element>::deleteTarget ()
{
  if (iTarget) {
    delete iTarget;
    iTarget = 0;
  } ; /* endif */
  return *this;
}
