#ifndef _IVBVCLSP_
  #define _IVBVCLSP_
/*******************************************************************************
* FILE NAME: ivbvclsp.h                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBVariableClassPointer - Variable template class for pointer classes.    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*******************************************************************************/

#ifndef _IVBVCLSS_
  #include <ivbvclss.hpp>
#endif

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

template < class Element >
class IVBVariableClassPointer : public IVBVariableClassBase
{
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
 -----------------------------------------------------------------------------*/
  IVBVariableClassPointer ();

virtual
  ~IVBVariableClassPointer ();

/*-------------------------------- Attributes ----------------------------------
| These operations can be used to query and change the attributes:             |
|   target            - Query the target attribute                             |
|   setTarget         - Set the target attribute                               |
|   targetId          - target attribute notification id                       |
|   targetPtr         - Query the target attribute as a pointer.               |
 -----------------------------------------------------------------------------*/
Element
  target () const;

IVBVariableClassPointer <Element>
 &setTarget (Element newTarget);

IVBVariableClassPointer <Element>
 &IVBVariableClassPointer <Element>::deleteTarget ();

Element
  targetPtr () const;

private:
/*--------------------------------- PRIVATE ----------------------------------*/
  Element iTarget;
};

#if ! defined (__TEMPINC__)
#include <ivbvclsp.c>
#endif

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* _IAVLVAR_ */
