#ifndef _IVBVCLSS_
  #define _IVBVCLSS_
/*******************************************************************************
* FILE NAME: ivbvclss.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBVariableClassBase - VB variable class base.                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
*******************************************************************************/
#ifndef _IVBDEFS__
#include <ivbdefs.h>
#endif

#ifndef _ISTDNTFY_
  #include <istdntfy.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBVariableClassBase : public IStandardNotifier {

public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
------------------------------------------------------------------------------*/
  IVBVariableClassBase ();

virtual
  ~IVBVariableClassBase ();

/*-------------------------------- Attributes ----------------------------------
| These operations can be used to query and change the attributes:             |
|                                                                              |
| isAutoDeleteTarget  - Query the auto delete target attribute for pointer     |
|                       variable types.                                        |
| setAutoDeleteTarget - Set the auto delete target attribute for pointer       |
|                       variable types.                                        |
------------------------------------------------------------------------------*/
virtual Boolean
  isAutoDeleteTarget       ( ) const;

virtual IVBVariableClassBase
 &setAutoDeleteTarget      ( Boolean autoDeleteTarget=true );

/*-------------------------------- Events --------------------------------------
| These are notification events provided:                                      |
|   targetId          - target attribute notification id.                      |
------------------------------------------------------------------------------*/
static INotificationId const
  IVB_IMPORT targetId;

protected:
/*--------------------------------- PRIVATE ----------------------------------*/
  Boolean iAutoDeleteTarget;
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* _IVBVCLSS_ */
