#ifndef _IVBVPART_
  #define _IVBVPART_
/*******************************************************************************
* FILE NAME: ivbvpart.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBVariablePartBase - VB variable part base.                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
*******************************************************************************/

#ifndef _IVBVCLSS_
  #include <ivbvclss.hpp>
#endif

#ifndef _IOBSERVR_
  #include <iobservr.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBVariablePartBase : public IVBVariableClassBase, public IObserver {

public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
------------------------------------------------------------------------------*/
  IVBVariablePartBase ();

virtual
  ~IVBVariablePartBase ();

protected:
/*--------------------------------- PROTECTED---------------------------------*/
virtual IObserver
  &dispatchNotificationEvent  ( const INotificationEvent& anEvent);

};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* _IVBVPART_ */
