#ifndef _IVBVPMSZ_
  #define _IVBVPMSZ_

/*******************************************************************************
* FILE NAME: ivbvpmsz.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBMinSizeViewPortHandler      - Makes viewport work with a multicell     *
*                                     canvas                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
*******************************************************************************/

#ifndef _ISIZEHDR_
  #include <isizehdr.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

class IViewPort;

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

//**************************************************************************
// Class:   IVBMinSizeViewPortHandler                                      *
//                                                                         *
// Purpose: Attach this handler to a viewport when the child of the        *
//          viewport is a multicell canvas.  This handler will grow the    *                       *
//          multicell canvas when the size of the viewport is larger than  *
//          the minimum size of the multicell canvas and add scroll bars   *
//          when the minimum size of the multicell is larger than the      *
//          size of the viewport.                                          *
//                                                                         *
//**************************************************************************
class IVBMinSizeViewPortHandler : public IResizeHandler {
public:
virtual IHandler
 &handleEventsFor       ( IViewPort* viewport ),
 &stopHandlingEventsFor ( IViewPort* viewport );

protected:
virtual Boolean
  windowResize ( IResizeEvent& event );

private:
#ifdef __OS2__
virtual IHandler
 &handleEventsFor       ( IWindow* window ),
 &stopHandlingEventsFor ( IWindow* window );
#endif
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
