/*******************************************************************************
* FILE NAME: ivbvprt.c                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBVariablePart - Variable template class for parts.                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*******************************************************************************/

#ifndef _IVBVPRT_
  #include <ivbvprt.h>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif

#include <ivbdefs.h>

/*------------------------------------------------------------------------------
| IVBVariablePart <Element>::IVBVariablePart                                   |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariablePart <Element>::IVBVariablePart ()
  : IVBVariablePartBase ()
{
  iTarget.enableNotification();
  handleNotificationsFor (iTarget);
}

/*------------------------------------------------------------------------------
| IVBVariablePart <Element>::~IVBVariablePart                                  |
|                                                                              |
| Standard destructor.                                                         |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariablePart <Element>::~IVBVariablePart ()
{
  stopHandlingNotificationsFor (iTarget);
}

/*------------------------------------------------------------------------------
| IVBVariablePart <Element>::target                                            |
|                                                                              |
| Returns the target attribute.                                                |
------------------------------------------------------------------------------*/
template < class Element >
Element& IVBVariablePart <Element>::target ()
{
  return iTarget;
}

/*------------------------------------------------------------------------------
| IVBVariablePart <Element>::targetPtr                                         |
|                                                                              |
| Returns the target attribute.                                                |
------------------------------------------------------------------------------*/
template < class Element >
Element* IVBVariablePart <Element>::targetPtr ()
{
  return &iTarget;
}

/*------------------------------------------------------------------------------
| IVBVariablePart <Element>::setTarget                                         |
|                                                                              |
| Sets the target attribute.                                                   |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariablePart <Element>& IVBVariablePart <Element>::setTarget
  (Element newTarget)
{
  stopHandlingNotificationsFor (iTarget);
  iTarget = newTarget;
  iTarget.enableNotification();
  handleNotificationsFor (iTarget);
  notifyObservers(INotificationEvent(VBINITIALIZEID, *this));
  notifyObservers(INotificationEvent(targetId, *this));
  return *this;
}

/*------------------------------------------------------------------------------
| IVBVariablePart <Element>::setTarget                                         |
|                                                                              |
| Sets the target attribute.                                                   |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariablePart <Element>& IVBVariablePart <Element>::setTarget
  (Element* newTarget)
{
  return setTarget(*newTarget);
}
