#ifndef _IVBVPRT_
  #define _IVBVPRT_
/*******************************************************************************
* FILE NAME: ivbvprt.h                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBVariablePart - Variable template class for non pointer parts.          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*******************************************************************************/

#ifndef _IVBVPART_
  #include <ivbvpart.hpp>
#endif

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

template < class Element >
class IVBVariablePart : public IVBVariablePartBase
{
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
 -----------------------------------------------------------------------------*/
  IVBVariablePart ();

virtual
  ~IVBVariablePart ();

/*-------------------------------- Attributes ----------------------------------
| These operations can be used to query and change the attributes:             |
|   target            - Query the target attribute.                            |
|   setTarget         - Set the target attribute.                              |
|   targetId          - target attribute notification id.                      |
|   targetPtr         - Query the target attribute as a pointer.               |
 -----------------------------------------------------------------------------*/
Element&
  target ();

IVBVariablePart <Element>
 &setTarget (Element newTarget),
 &setTarget (Element* newTarget);

Element*
  targetPtr () ;

private:
/*--------------------------------- PRIVATE ----------------------------------*/
  Element iTarget;
};

#if ! defined (__TEMPINC__)
#include <ivbvprt.c>
#endif

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* _IVBVPRT_ */
