/*******************************************************************************
* FILE NAME: ivbvprtp.c                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class(es):                                     *
*    IVBVariablePartPointer - Variable template class for pointer to a part.          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*******************************************************************************/

#ifndef _IVBVPRTP_
  #include <ivbvprtp.h>
#endif

#ifndef _INOTIFEV_
  #include <inotifev.hpp>
#endif

#ifndef _IWINDOW_
  #include <iwindow.hpp>
#endif

#include <ivbdefs.h>

/*------------------------------------------------------------------------------
| IVBVariablePartPointer <Element>::IVBVariablePartPointer                     |
|                                                                              |
| Standard constructor.                                                        |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariablePartPointer <Element>::IVBVariablePartPointer ()
  : IVBVariablePartBase (), iTarget (0)
{
}

/*------------------------------------------------------------------------------
| IVBVariablePartPointer <Element>::~IVBVariablePartPointer                    |
|                                                                              |
| Standard destructor.                                                         |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariablePartPointer <Element>::~IVBVariablePartPointer ()
{
  if (iTarget) {
    stopHandlingNotificationsFor (*iTarget);
    if (iAutoDeleteTarget) {
      delete iTarget;
    } /* endif */
  } /* endif */
}

/*------------------------------------------------------------------------------
| IVBVariablePartPointer <Element>::target                                     |
|                                                                              |
| Returns the target attribute.                                                |
------------------------------------------------------------------------------*/
template < class Element >
Element IVBVariablePartPointer <Element>::target () const
{
  return iTarget;
}

/*------------------------------------------------------------------------------
| IVBVariablePartPointer <Element>::targetPtr                                  |
|                                                                              |
| Returns the target attribute.                                                |
------------------------------------------------------------------------------*/
template < class Element >
Element IVBVariablePartPointer <Element>::targetPtr () const
{
  return iTarget;
}

/*------------------------------------------------------------------------------
| IVBVariablePartPointer <Element>::setTarget                                  |
|                                                                              |
| Sets the target attribute.                                                   |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariablePartPointer <Element>& IVBVariablePartPointer <Element>::setTarget
  (Element newTarget)
{
  if (iTarget != newTarget) {
    if (iTarget) {
      stopHandlingNotificationsFor (*iTarget);
      if (iAutoDeleteTarget) {
        delete iTarget;
      } /* endif */
    } /* endif */
    iTarget = newTarget;
    if (iTarget) {
      iTarget->enableNotification();
      handleNotificationsFor (*iTarget);
    } /* endif */
  } /* endif */
  notifyObservers(INotificationEvent(VBINITIALIZEID, *this));
  notifyObservers(INotificationEvent(targetId, *this));
  return *this;
}

/*------------------------------------------------------------------------------
| IVBVariablePartPointer <Element>::dispatchNotificationEvent                  |
|                                                                              |
| Sets the target attribute.                                                   |
------------------------------------------------------------------------------*/
template < class Element >
IObserver& IVBVariablePartPointer <Element>::
  dispatchNotificationEvent  ( const INotificationEvent& anEvent)
{
  notifyObservers (anEvent);
  if (( anEvent.notificationId() == IStandardNotifier::deleteId ) ||
      ( anEvent.notificationId() == IWindow::deleteId )) {
    iTarget = 0;
  } ; /* endif */
  return *this;
}

/*------------------------------------------------------------------------------
| IVBVariablePartPointer <Element>::deleteTarget                               |
|                                                                              |
| Delete the target attribute.                                                 |
------------------------------------------------------------------------------*/
template < class Element >
IVBVariablePartPointer <Element>&
  IVBVariablePartPointer <Element>::deleteTarget ()
{
  if (iTarget) {
    stopHandlingNotificationsFor (*iTarget);
    delete iTarget;
    iTarget = 0;
    notifyObservers(INotificationEvent(VBINITIALIZEID, *this));
    notifyObservers(INotificationEvent(targetId, *this));
  } ; /* endif */
  return *this;
}
