#ifndef _IVBVPRTP_
  #define _IVBVPRTP_
/*******************************************************************************
* FILE NAME: ivbvprtp.h                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBVariablePartPointer - Variable template class for pointer to a part.   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*******************************************************************************/

#ifndef _IVBVPART_
  #include <ivbvpart.hpp>
#endif

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

template < class Element >
class IVBVariablePartPointer : public IVBVariablePartBase
{
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
 -----------------------------------------------------------------------------*/
  IVBVariablePartPointer ();

virtual
  ~IVBVariablePartPointer ();

/*-------------------------------- Attributes ----------------------------------
| These operations can be used to query and change the attributes:             |
|   target            - Query the target attribute.                            |
|   setTarget         - Set the target attribute.                              |
|   targetId          - target attribute notification id.                      |
|   targetPtr         - Query the target attribute as a pointer.               |
 -----------------------------------------------------------------------------*/
Element
  target () const;

IVBVariablePartPointer <Element>
 &setTarget (Element newTarget);

IVBVariablePartPointer <Element>
 &IVBVariablePartPointer <Element>::deleteTarget ();

Element
  targetPtr () const;

protected:
IObserver&
  dispatchNotificationEvent  ( const INotificationEvent& anEvent);

private:
/*--------------------------------- PRIVATE ----------------------------------*/
  Element iTarget;
};

#if ! defined (__TEMPINC__)
#include <ivbvprtp.c>
#endif

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* _IVBVPRTP_ */
