/********************************************************************************/
/* File:  sdspmbsq.inl                                                          */
/* Class: IDSParameterBufferSequence                                            */
/*                                                                              */
/* IDSParameterBufferSequence - sequence of parm buffers                        */
/********************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#include "sdspmbsq.hpp"

/*------------------------------------------------------------------------------
|   bindToStatement - bind all parameters in seq to statement                  |
------------------------------------------------------------------------------*/
inline void IDSParameterBufferSequence::bindToStatement(
                                           ISQLStatement* pSqlStatement)
{
  statementInfo info(pSqlStatement);
  allElementsDo (bindParameter, &info);
}

/*------------------------------------------------------------------------------
|   bindParameter  - bind a parameter to a statement                           |
------------------------------------------------------------------------------*/
inline Boolean IDSParameterBufferSequence::bindParameter(
                                              IPOBufferBase*& pBuffer,
                                               void* someInfo)
{
  statementInfo* info = (statementInfo*)someInfo;
  pBuffer->bindToParameter(info->number++, info->sqlStatement);
  return true;
}
