/****************************************************************************/
/* File:   sdssqlst.hpp                                                     */
/* Class:  ISQLStatement                                                    */
/*                                                                          */
/****************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#ifndef _SDSSQLST_HPP_
#define _SDSSQLST_HPP_

#include <istring.hpp>

class DatastoreDB2;
class DatastoreODBC;
class ISQLStatementProxy;

class _Export ISQLStatement
{
  public:
    ISQLStatement(DatastoreDB2* pIDatastore);
    ISQLStatement(DatastoreODBC* pIDatastore);
    ~ISQLStatement();

    Boolean executeDirect(const IString& statement);
    ISQLStatement& prepare(const IString& statement);
    Boolean execute();
    Boolean fetch();
    long rowCount();
    short numResultCols();
    short numParams();
    Boolean moreResults();
    Boolean bindColumn(short colPos, short fCType, void *pBuf,
                              long cbBufMax, void *pcbBuf);
    ISQLStatement& bindParameter(short parPos, short fParamType,
                                 short fCType, short fSqlType, long cbParDef,
                                 short ibScale, void *pBuf, long cbBufMax,
                                 void *pcbBuf
                                 );
    ISQLStatement& rollback();
    ISQLStatement& getSuccessInfo(long& code, IString& state);

  private:
    ISQLStatementProxy *pSqlPrx;
};

#endif
