/****************************************************************************/
/* File:   sdsstat.hpp                                                      */
/* Class:                                                                   */
/*         IDSStatement                                                     */
/*                                                                          */
/****************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#ifndef _SDSSTAT_HPP_
#define _SDSSTAT_HPP_

#include <iseq.h>
#include <istring.hpp>
#include "sdsclbsq.hpp"
#include "sdspmbsq.hpp"
#include "sdssqlst.hpp"
#include "idaenv.hpp"
#include "idsexc.hpp"

class _Export IDSStatement
{
  public:
    IDSStatement( const char* aStatement, DatastoreDB2* aDatastore );
    IDSStatement( const char* aStatement, DatastoreODBC* aDatastore );
    ~IDSStatement();

    virtual IDSStatement& execute() = 0;

  protected:
    IDSParameterBufferSequence parameterBuffers;
    IDSColumnBufferSequence columnBuffers;
    const IString iStatement;
    ISQLStatement* iSQLStatement;
};

#include "sdsstat.inl"

#endif
