/******************************************************************************/
/* File:   sdsstat.inl                                                        */
/* Class:                                                                     */
/*         IDSStatement                                                       */
/*                                                                            */
/******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

//#include "sdsstat.hpp"

/*-----------------------------------------------------------------+
|  Constructor                                                     |
+-----------------------------------------------------------------*/
inline IDSStatement::IDSStatement(const char* aStatement,
                           DatastoreDB2* aDatastore )
          :iStatement(aStatement),
           iSQLStatement( new ISQLStatement( aDatastore ) )
{

}

inline IDSStatement::IDSStatement(const char* aStatement,
                           DatastoreODBC* aDatastore )
          :iStatement(aStatement),
           iSQLStatement( new ISQLStatement( aDatastore ) )
{

}

/*-----------------------------------------------------------------+
|  Destructor                                                      |
+-----------------------------------------------------------------*/
inline IDSStatement::~IDSStatement()
{
  if (iSQLStatement != 0)
  {
   delete iSQLStatement;
  }
}
