/******************************************************************************/
/* File:   sdsstse.inl                                                        */
/* Class:                                                                     */
/*         IDSStatementSelect                                                 */
/*                                                                            */
/******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

//#include "sdsstse.hpp"

/*-----------------------------------------------------------------+
|  Constructor                                                     |
+-----------------------------------------------------------------*/
inline IDSStatementSelect::IDSStatementSelect(const char* aStatement,
                           DatastoreDB2* aDatastore )
          :IDSStatement(aStatement,aDatastore)
{

}

inline IDSStatementSelect::IDSStatementSelect(const char* aStatement,
                           DatastoreODBC* aDatastore )
          :IDSStatement(aStatement,aDatastore)
{

}

/*-----------------------------------------------------------------+
|  Destructor                                                      |
+-----------------------------------------------------------------*/
inline IDSStatementSelect::~IDSStatementSelect()
{

}

inline IDSStatementSelect&
IDSStatementSelect::execute()
{
    parameterBuffers.bindToStatement( iSQLStatement );
    iSQLStatement->executeDirect(iStatement);
    columnBuffers.bindToStatement( iSQLStatement );
    return *this;
}

inline Boolean
IDSStatementSelect::executeFetch()
{
    return iSQLStatement->fetch();
}
