/*
 *   COMPONENT_NAME: somc
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
        Last change:  KAS  26 Oct 94    6:01 pm
 */
/*
 *    %Z% %I% %W% %G% %U% [%H% %T%]
 */

/*
 */

/*
 *         File:    smlib.h.
 *     Contents:    General macros used by the SOM Compiler and the
 *                  emitters.
 *
 *                  [12/06/93] Partial Entry structures #1089
 *                  [01/14/94] Changes for SC LITE #1184
 *                  [04/01/94] Added Mac form for "#include <private" #2752
 */

#ifndef smlib_h
#define smlib_h
#include <somc_msg.h>
#ifndef _WIN32
#include <somport.h>
#endif
#include <setjmp.h> /* #1960 */

#ifdef SOMWATCH
#ifdef __MAC__ /* #2752 */
  #include <private:somwatch.h>
#else
  #include <private/somwatch.h>
#endif /* __MAC__ */
#define basemalloc  somwatchMalloc
#define basefree    somwatchFree
#define baserealloc somwatchRealloc /* #1112 */
#define basecalloc  somwatchCalloc /* #1112 */
#else
#define basemalloc  malloc
#define basefree    free
#define baserealloc realloc /* #1112 */
#define basecalloc  calloc /* #1112 */
#endif


#define SOMTOVERRIDE_TYPE(ep) (ep->type == SOMTOverrideMethodE || ep->u.m.omethod)
#define SOMTVALIDENTRY(e,m) ((somtgetatt(e, "class") ? TRUE : FALSE) == m)
#define SMUNKNOWNTYPE(e)    fprintf(stderr, "\"%s\": %d " \
                                      "[%d]. \"%s\"\n", __FILE__, __LINE__,\
                                       e->type, e->name)
#define somtfindBaseType(ep) (somtfindBaseEp(ep)->type)
/*
 * Error handling macros.  We keep a track of our various errors & warnings
 * in a global structure so that emitters can also post errors.
 * They can do this in one of two ways - calling the somtwarn, somterror,
 * somtfatal, somtinternal functions, or using these macros.
 */
#define SMANYERRORS()       (somtg_f.ERROR || somtg_f.FATAL || somtg_f.INTERNAL)
#define SMANYFATAL()        (somtg_f.FATAL || somtg_f.INTERNAL)
#define SMWARNCOUNT()       (somtg_f.WARN)
#define SMERRORCOUNT()      (somtg_f.ERROR + somtg_f.FATAL + somtg_f.INTERNAL)
#define SMPOSTERROR(type)   (somtg_f.type++)
#define SOMTSTAR            (somtaddstar ? "*" : "")
#define SOMTQUAL(cls)       (cls->sname && cls->sname[1])
#define ATTMAP(n)           ((!somtg_f.idl && n && (*n == 'c')) ? somtattMap(n) : n)
#define MSGSET STK
#ifdef __RESTRICT_MEMORY__
#define MAX_MSGSIZE 256
#else
#define MAX_MSGSIZE 500
#endif

/*
 * setjmp/longjmp exit details #1960
 */

typedef struct {
    jmp_buf jmpbuf;
    bool called;
    int  status;
} SOMTExitBuf;

#define SOMTSETEXIT(buf)    if (!buf.called) setjmp(buf.jmpbuf) /* #1960 */

#define SOMT_IDL_SEQUENCE_LEN_1  13             /* IDL_SEQUENCE */
#define SOMT_IDL_SEQUENCE_LEN_2  22             /* seq<%10d> */
#define SOMT_IDL_SEQUENCE_LEN (SOMT_IDL_SEQUENCE_LEN_1+SOMT_IDL_SEQUENCE_LEN_2)
#define SOMT_REMOVE_IDL_SEQUENCE(s)   ((*s == '/') ? \
                                         s+SOMT_IDL_SEQUENCE_LEN_2 : s)

/*
 * DBCS enabling macros
 */
#ifdef _DBCS
  #define DBCSBLANK        0x8140
  #define DBCSTOINT(buf)   ((((int)*(buf))<<8)+((int)*((buf)+1)))
  #define DBCSCOPY(buf,c)  if(isDBCS(c))\
    {*(buf)++=(char)((c)>>8);*(buf)++=(char)((c)&0xFF);}\
    else *(buf)++=(char)(c)
  #define DBCSSCAN(buf)    somtdbcsScan((char **)&(buf))
  #define DBCSINCR(buf)    ((buf) += isDBCS(*(buf))? 2: 1)
  #define DBCSCHAR(buf)    (isDBCS(*(buf)) ? DBCSTOINT(buf) : (int)(*(buf)))
  #define DBCS_output      dbcsOutput
  #define dbcsOutput(c,fp) ((isDBCS(c) && (putc((char)(c>>8), fp) == EOF)) \
                                           ? EOF \
                                           : putc((char) (c&0x00FF), fp))
  #define DBCS_strchr      somtdbcsStrchr
  #define DBCS_strrchr     somtdbcsStrrchr
  #define DBCS_strstr      somtdbcsStrstr
  #define DBCS_preincr     somtdbcsPreincr
  #define DBCS_postincr    somtdbcsPostincr
  #define isDBCS           somtisDbcs
  #define DBCS_isspace(c)  ((c >= 0) && (c < 256) && isspace(c))
#else
  #define DBCSCOPY(buf,c)  (*(buf)++=(char)(c))
  #define DBCSSCAN(buf)    ((int)(*(buf)++))
  #define DBCSINCR(buf)    (++(buf))
  #define DBCSCHAR(buf)    ((int)(*(buf)))
  #define DBCS_output      putc
  #define DBCS_strchr      strchr
  #define DBCS_strrchr     strrchr
  #define DBCS_strstr      strstr
  #define DBCS_preincr     ++
  #define DBCS_postincr(x) ((x)++)
  #define isDBCS(s)        (FALSE)
  #define DBCS_isspace(c)  (isspace(c))
#endif /* _DBCS */

/*
 * ISO LATIN 8859.1 Characater Set
 */
#define SOMTISALNUM(c)        (isalnum(c) || c == '_' || IS_ISO_LATIN_8859_1(c))
#define ISO_LATIN_8859_1_START  192
#define ISO_LATIN_8859_1_FINISH 255
#define IS_ISO_LATIN_8859_1(c)  (c >= ISO_LATIN_8859_1_START && \
                                 c <= ISO_LATIN_8859_1_FINISH && \
                                 c != 215 && c != 247)

/*
 * Enum for parent traversal.
 */
typedef enum _SMTraverse {SMTraverseAll, SMTraverseOnce, SMTraverseMany}
        SMTraverse;

/*
 * Command line flags and error structure.
 */
typedef struct {
    unsigned verbose:1;
    unsigned quiet:1;
    unsigned warn:1;
    unsigned extra:1;
    unsigned comments:1;
    AttList *atts;
    unsigned lex:1;
    unsigned yacc:1;
    unsigned release:1;
    unsigned stab:1;
    unsigned qualify:1;
    unsigned idl:1;
#ifdef __RESTRICT_MEMORY__
#define MAX_NO_EMITTERS 4
#else
#define MAX_NO_EMITTERS 32
#endif
    char *emitters[MAX_NO_EMITTERS];
    char *progname;
    int ERROR;
    int WARN;
    int FATAL;
    int INTERNAL;
    unsigned append:1;          /* Append to files, like -memitappend */
    unsigned level2:1;          /* level 2 extensions */
    unsigned noint:1;           /* no "int" warning */
    size_t commentsize;         /* size of comment buffer */
    unsigned useshort:1;        /* use short names */
    AttList *pragmas;           /* list of pragmas */
    Mlist *glbemits;            /* list of types to globally emit */
    unsigned fullyqualified:1;  /* TRUE if names have been fullyqualified */
    unsigned tcdone:1;          /* TRUE if typecodes have been created */
    unsigned relchk:1;          /* TRUE if you want release order checking */
    unsigned binary:1;          /* TRUE if somtopenEmitFile should fopen in binary mode #8694 */
} Flags;

/*
 * Global variables - that are really macros
 */

#define somtcommentsize      somtg_f.commentsize
#define somtpragmaList       somtg_f.pragmas
#define somtglbemits         somtg_f.glbemits
#define somtfullyqualified   somtg_f.fullyqualified
#define somttcdone           somtg_f.tcdone
#define somtrelchk           somtg_f.relchk

#define ARG_STRING          ((*argc)--, *(*argv)++)
#define MAX_ARG_LIST_LENGTH 2048
#define SOMTSABUF           (4*(FILENAME_MAX+2)+1) /* ::id::id::id::id */
#define SOMT_MSG_SIZE       MAX_ARG_LIST_LENGTH + SOMTSABUF

typedef struct {
    char *name;
    char *desc;
    short len;
} BaseType;

/*
 * Emitter function prototype:
 */
typedef FILE* (*EmitFn)(char*,Entry*,Stab*);

/*
 * External function prototypes from smlib.c, smload.c, smtypes.c, smdesc.c,
 * smmsg.c
 */
#ifdef _WIN32
SOMEXTERN int somttraverseParents(FILE *fp, Entry * cls, Entry *arg, int (*fn)(FILE*,Entry*,Entry*), SMTraverse flg);
#endif
SOMEXTERN AttList *somtattalloc(MemBuf *membuf, char *name, char *value);
SOMEXTERN AttList *somtgetap(AttList *ap, char *att);
SOMEXTERN EmitFn somtload(char *fileName, char *functionName, void **modHandle);
SOMEXTERN Entry *somtfindBaseEp(Entry *ep);
SOMEXTERN Entry *somtgetType(char *name, SOMTTypes type);
SOMEXTERN FILE *somtokfopen(char *path, char *mode);
#if defined(_WIN32)
SOMEXTERN int somtokfprintf(FILE *, const char *, ...);
SOMEXTERN int somtokfputs(const char *, FILE *);
SOMEXTERN int somtokfputc(const char, FILE *);
SOMEXTERN char *somtokfgets(char *, int, FILE *);
SOMEXTERN void somtokrewind(FILE *);
SOMEXTERN int somtokrename(const char*, const char *);
#endif
SOMEXTERN FILE *somtopenEmitFile(char *file, char *ext);
SOMEXTERN bool somtisDbcs(int c);
SOMEXTERN bool somtremoveExt(char *name, char *ext, char *buf);
SOMEXTERN char *somtaddExt(char *name, char *ext, char *buf);
SOMEXTERN char *somtarrayToPtr(Entry *ep, char *stars, char *buf);
SOMEXTERN char *somtattNormalise(char *name, char *buf);
SOMEXTERN char *somtbasename(char *path);
SOMEXTERN char *somtctos(Const *con, char *buf);
SOMEXTERN char *somtdbcsPostincr(char **p);
SOMEXTERN char *somtdbcsPreincr(char **p);
SOMEXTERN char *somtdbcsStrchr(char *s, int c);
SOMEXTERN char *somtdbcsStrrchr(char *s, int c);
SOMEXTERN char *somtdbcsStrstr(char *s1, char *s2);
SOMEXTERN char *somteptotype(Entry *ep, char *ptrs, char *buf);
SOMEXTERN char *somtgetDesc(Stab *stab, Entry *cls, Entry *method, char *desc, bool addQuotes, bool use, bool versflg);
SOMEXTERN char *somtgetVersion(char *sccsid, char *version);
SOMEXTERN char *somtgetgatt(char *s);
SOMEXTERN char *somtnextword(const char *s, char *buf);
SOMEXTERN char *somtnormaliseDesc(char *desc, char *normal);
SOMEXTERN char *somtsatos(char **sa, char *sep, char *buf);
SOMEXTERN char *somtsearchFile(char *file, char *path, char *envvar);
SOMEXTERN char *somtskipws(const char *s);
SOMEXTERN char *somtstringFmt(char *fmt, ...);
SOMEXTERN char *somttype(SOMTTypes type);
SOMEXTERN char *somtuniqFmt(MemBuf *membuf, char *fmt, ...);
SOMEXTERN int somtargFlag(int *argc, char ***argv);
SOMEXTERN int somtattjoin(register AttList *ap1, AttList *ap2);
SOMEXTERN int somtdbcsLastChar(char *buf);
SOMEXTERN int somtdbcsScan(char **buf);
SOMEXTERN int somtdiskFull(FILE *fp);
SOMEXTERN int somtfclose(FILE *fp);
SOMEXTERN int somtfexists(char *file);
SOMEXTERN int somtisparent(Entry *cls, Entry *parent);
SOMEXTERN int somtmget(int setnum, int msgnum, char *msgbuf);
SOMEXTERN int somtmopen(char *filename);
SOMEXTERN int somtmprintf(int setnum, int msgnum, ...);
SOMEXTERN int somtokremove(char *file);
SOMEXTERN int somtunload(void *modHandle);
SOMEXTERN int somtwriteaccess(char *file);
SOMEXTERN void *somtsmalloc(size_t nbytes, bool clear);
SOMEXTERN void somtaddGAtt(MemBuf **membuf, AttList **ap, char *buf);
SOMEXTERN void somtcalcFileName(char *def, char *over, char *ext);
SOMEXTERN void somtcleanFilesFatal(int status);
SOMEXTERN void somtemitTypes(FILE *fp, Mlist *mp, Stab *stab);
SOMEXTERN void somterror(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtfatal(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtinternal(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtmclose(void);
SOMEXTERN void somtmsg(char *file, long lineno, char *fmt, ...);
SOMEXTERN void somtreadDescFile(Stab *stab, char *file);
SOMEXTERN void somtsetDefaultDesc(Stab *stab);
SOMEXTERN void somtsetEmitSignals(void(*cleanup) (int), void (*internal) (int));
SOMEXTERN void somtsetTypeDefn(Entry *type, Entry *ep, char *ptrs, Entry *ret, bool array);
SOMEXTERN void somtsetext(int csc);
SOMEXTERN void somtshowVersion(char *s, char *progname, char *sccsid);
SOMEXTERN void somtsmfree(void *first, ...);
SOMEXTERN void somtunsetEmitSignals(void);
SOMEXTERN void somtwarn(char *file, long lineno, char *fmt, ...);
SOMEXTERN char *somtuppercase(char *s, char *buf);
SOMEXTERN char *somtlowercase(char *s, char *buf);
SOMEXTERN char *somtdbcsuppercase(char *s, char *buf);
SOMEXTERN char *somtdbcslowercase(char *s, char *buf);
SOMEXTERN void somtresetEmitSignals(void);
SOMEXTERN size_t somtsizeofEntry(SOMTTypes type);
SOMEXTERN char *somtepname(Entry *ep, char *buf, bool suppressImpctxCheck);
SOMEXTERN char *somtgenSeqName(long n, Entry *base, char *buf, bool fullname);
SOMEXTERN void somtmrifatal(char *file, long lineno, int msgnum,...);
SOMEXTERN void somtmriinternal(char *file, long lineno, int msgnum,...);
SOMEXTERN void somtmrierror(char *file, long lineno, int msgnum,...);
SOMEXTERN void somtmrimsg(char *file, long lineno, int msgnum,...);
SOMEXTERN void somtmriwarn(char *file, long lineno, int msgnum,...);
SOMEXTERN void somtsetInternalMessages(char *too_long, char *cant_continue, char *segv, char *bus);
SOMEXTERN bool somtisvoid(Entry *type, char *defn);
SOMEXTERN bool somtreturnsStruct(Entry *ep);
SOMEXTERN bool somtreturnsPtr(Entry *ep);
SOMEXTERN char *somtsimpleName(Entry *ep);
SOMEXTERN void somtqualifyNames(Stab * stab, bool fully);
SOMEXTERN Entry *somtfindBaseEpNonPtr(Entry *ep);
SOMEXTERN bool somtprocessTraps(void);
SOMEXTERN Mlist *somtallocMlist(Entry * ep); /* #206 */
SOMEXTERN Mlist *somtmlistend(Mlist * mp, char *name); /* #206 */
SOMEXTERN bool somtisMutRef(Entry *ep, Mlist *seen, bool isself, long level); /* #206 */
SOMEXTERN Mlist * somtfreeMlist(Mlist *mp); /* #206 */
SOMEXTERN Mlist * somtdupMlist(Mlist *mp, Entry *ep); /* #206 */
SOMEXTERN void somtfreeWorld(); /* #1112 */
SOMEXTERN void somtinitMalloc(bool dynamic); /* #1112 */
SOMEXTERN void somtInitialiseEmitlib(void); /* #1180 */
SOMEXTERN void somtInitialiseSmmeta(void); /* #1180 */
SOMEXTERN void somtInitialiseCreatetc(void); /* #1180 */
SOMEXTERN void somtInitialiseSmtypes(void); /* #1180 */
SOMEXTERN void somtInitialiseSomc(void); /* #1180 */
SOMEXTERN void somtInitialiseSmsmall(void);
SOMEXTERN char *somtattMap(char *name);
SOMEXTERN void somtexit(SOMTExitBuf *ebuf, int status); /* #1960 */

/*
 * In emitlib.c
 */
SOMEXTERN void somtdymain(char *file, Entry *cls, EmitFn emitfn, char *emitter, int first, char *version, Stab *stab);
SOMEXTERN void somtaddHeader(char *file, FILE *fp, char *ext);

/*
 * Global variables
 */
#if (!defined(_WIN32) || defined(_WIN32_SOMC))
SOMEXTERN global Flags somtg_f;        /* Command line flags structure */

SOMEXTERN global MemBuf *somtg_membuf; /* Memory buffer for string allocation */

SOMEXTERN global Mlist *somtglbdefs;   /* Global defs */

SOMEXTERN global SMEXT somtext;        /* Different idl/oidl extensions */

SOMEXTERN global Stab *somtstab;       /* Pointer to symbol table */

SOMEXTERN global bool somtaddstar;     /* Cached copy of global modifier */

SOMEXTERN global bool somtrmstar;      /* Cached copy of global modifier */

SOMEXTERN global char *somtg_buf;      /* Comment/pass thru buffer */

SOMEXTERN global char *somtg_sccsid;

SOMEXTERN global char somtfilePath[];  /* input file full path */

SOMEXTERN global char somtfileStem[];  /* infput file stem */

SOMEXTERN global char somtoutPath[];   /* output file */

SOMEXTERN global char *(*somtgetAtt) (AttList *, char *, char **);

SOMEXTERN global Entry *somtmodule;    /* Pinter to last module encountered */

SOMEXTERN global Mlist *somtclassList; /* List of classes that sc emits */

SOMEXTERN global long somtsaved;       /* Bytes saved due to various
                                        * optimisations steps #1089 */

SOMEXTERN global void *(*somtmalloc)(size_t nbytes); /* #1112 */
SOMEXTERN global void (*somtfree)(void *bp);         /* #1112 */
SOMEXTERN global void *(*somtcalloc)(size_t nmemb, size_t size);  /* #1112 */
SOMEXTERN global void *(*somtrealloc)(void *bp, size_t nbytes); /* #1112 */

SOMEXTERN global void (*somtcleanup_f) (int); /* cleanup signal function to call */
SOMEXTERN global void (*somtinternal_f) (int);/* internal signal function to call */
SOMEXTERN global int somtopenEmitFileCalled; /* #1125, #1180 */

SOMEXTERN global SOMTExitBuf somtipcbuf;  /* #1960 - global buffer for the setmp/longjmp */

SOMEXTERN global SOMTExitBuf somtscbuf;   /* #1960 - global buffer for the setmp/longjmp */

SOMEXTERN global void *somtemitReturns; /* Emitter returns */ /* #1960 */

SOMEXTERN global void (*somtrealExit)(int status); /* #1960 real exit to call */

#else /* _WIN32 IS DEFINED */

SOMEXTERN global WIN32_DLLIMPORT Flags somtg_f;        /* Command line flags structure */

SOMEXTERN global WIN32_DLLIMPORT MemBuf *somtg_membuf; /* Memory buffer for string allocation */

SOMEXTERN global WIN32_DLLIMPORT Mlist *somtglbdefs;   /* Global defs */

SOMEXTERN global WIN32_DLLIMPORT SMEXT somtext;        /* Different idl/oidl extensions */

SOMEXTERN global WIN32_DLLIMPORT Stab *somtstab;       /* Pointer to symbol table */

SOMEXTERN global WIN32_DLLIMPORT bool somtaddstar;     /* Cached copy of global WIN32_DLLIMPORT modifier */

SOMEXTERN global WIN32_DLLIMPORT bool somtrmstar;      /* Cached copy of global WIN32_DLLIMPORT modifier */

SOMEXTERN global WIN32_DLLIMPORT char *somtg_buf;      /* Comment/pass thru buffer */

SOMEXTERN global WIN32_DLLIMPORT char *somtg_sccsid;

SOMEXTERN global WIN32_DLLIMPORT char somtfilePath[];  /* input file full path */

SOMEXTERN global WIN32_DLLIMPORT char somtfileStem[];  /* infput file stem */

SOMEXTERN global WIN32_DLLIMPORT char somtoutPath[];   /* output file */

SOMEXTERN global WIN32_DLLIMPORT char *(*somtgetAtt) (AttList *, char *, char **);

SOMEXTERN global WIN32_DLLIMPORT Entry *somtmodule;    /* Pinter to last module encountered */

SOMEXTERN global WIN32_DLLIMPORT Mlist *somtclassList; /* List of classes that sc emits */

SOMEXTERN global WIN32_DLLIMPORT long somtsaved;       /* Bytes saved due to various
                                        * optimisations steps #1089 */

SOMEXTERN global WIN32_DLLIMPORT void *(*somtmalloc)(size_t nbytes); /* #1112 */
SOMEXTERN global WIN32_DLLIMPORT void (*somtfree)(void *bp);         /* #1112 */
SOMEXTERN global WIN32_DLLIMPORT void *(*somtcalloc)(size_t nmemb, size_t size);  /* #1112 */
SOMEXTERN global WIN32_DLLIMPORT void *(*somtrealloc)(void *bp, size_t nbytes); /* #1112 */

SOMEXTERN global WIN32_DLLIMPORT void (*somtcleanup_f) (int); /* cleanup signal function to call */
SOMEXTERN global WIN32_DLLIMPORT void (*somtinternal_f) (int);/* internal signal function to call */
SOMEXTERN global WIN32_DLLIMPORT int somtopenEmitFileCalled; /* #1125, #1180 */

SOMEXTERN global WIN32_DLLIMPORT SOMTExitBuf somtipcbuf;  /* #1960 - global WIN32_DLLIMPORT buffer for the setmp/longjmp */

SOMEXTERN global WIN32_DLLIMPORT SOMTExitBuf somtscbuf;   /* #1960 - global WIN32_DLLIMPORT buffer for the setmp/longjmp */

SOMEXTERN global WIN32_DLLIMPORT void *somtemitReturns; /* Emitter returns */ /* #1960 */

SOMEXTERN global WIN32_DLLIMPORT void (*somtrealExit)(int status); /* #1960 real exit to call */

#endif /* _WIN32 DLLIMPORT sections */

#endif
