/*
 *   COMPONENT_NAME: somc
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
/* %Z% %I% %W% %G% %U% [%H% %T%] */

/*
 */

/*
 *         File:    smstd.h.
 *     Contents:    Standard header file with some useful #includes
 *                  and macros for all compiler/emitter development.
 */

#ifndef smstd_h
#define smstd_h

#ifdef __cplusplus      /* Turn off inlining of strcmp, etc for C++ */
#undef __STR__
#endif

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <stdlib.h>

#ifndef __SCLITE__
    #if defined (__STDC__) || defined (__EXTENDED__)
	#if defined (__OS2__) || defined (__WINDOWS__)   /* 11494 */
	    #include <io.h>
	#else
	    #include <unistd.h>
	#endif
    #else
	#define _NO_PROTO
    #endif
#endif

#ifndef TRUE
    #define TRUE 1
#endif
#ifndef FALSE
    #define FALSE 0
#endif

/*
 *  Standard typedefs:
 */
typedef int bool;

#if !defined(WIN32_DLLIMPORT)
  #if (defined(_WIN32) && !defined(_WIN32_SOMC))
    #if (_MSC_VER >= 900)
      #define WIN32_DLLIMPORT __declspec(dllimport)
    #elif (defined(__IBMC__) || defined(__IBMCPP__)) && defined(__WINDOWS__)
      /* IBM compiler defines */
      #define WIN32_DLLIMPORT __declspec(dllimport)
    #endif
  #else
    #define WIN32_DLLIMPORT /* Maps onto nothing by default */
  #endif
#endif

#define global /* Maps onto nothing, used as a prefix to global variables */

/*
 *  Standard NULL casts:
 */
#ifndef NULL
#define NULL   0
#endif
#define CNULL       ((char *)0)
#define FNULL       ((FILE *)0)
#define VNULL       ((void *)0)
#define INULL       ((int  *)0)
/*
 * from src/somk/somltype.h
 */
#ifndef SOMLINK
  #if defined(_CL386)
    #define SOMLINK _syscall
  #elif defined(applec)
    #define SOMLINK
  #elif defined(__OS2__)
    #if defined(__IBMCPP__) || defined(__IBMC__)
      #define SOMLINK _System
    #elif defined(__BCPLUSPLUS__) || (__BORLANDC__)
      #define SOMLINK _syscall
    #elif defined(__SOMLPRAGMA__)
      #define SOMLINK
    #elif defined(_SOL_PPC)
      #define SOMLINK
    #else
      #define SOMLINK _System
    #endif
  #elif defined(__WINDOWS__)   /* 11494 */
    #define SOMLINK __stdcall
  #elif defined(_MSDOS) || defined(__MSDOS__) || defined(__SC__)
    #if defined(_WDOS) || defined(__SOMEMIT__)
      #ifdef __SC__
	#define SOMLINK
      #endif
    #else
      #define SOMLINK __loadds
      #define WIN16_SOMLINK __loadds
      #ifndef _WIN16
	#define _WIN16
      #endif
    #endif
  #else
    #define SOMLINK
  #endif
#endif

#ifndef SOMLINK
  #ifdef __IBMCPP__
    #define SOMLINK _System
  #else
    #ifdef _CL386
      #define SOMLINK _syscall
    #else
      #define SOMLINK
    #endif
  #endif
#endif

#endif /* smstd_h */
