/*
 *   COMPONENT_NAME: somd
 *
 *   ORIGINS: 27
 *
 *
 *   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
/* %Z% %I% %W% %G% %U% [%H% %T%] */


/*
 *  somthrd.h - include file for Thread Service Provider Interfaces (SPIs)
 */

#ifndef SOM_somthrd_h
#define SOM_somthrd_h

#include <som.h>

typedef void somTD_SOMThreadProc(void * data);
/* note: for OS/2 CSet++, somTD_SOMThreadProc must use _Optlink linkage */

typedef unsigned long SOMLINK somTD_SOMStartThread(OUT somToken * thrd,
						   IN somTD_SOMThreadProc proc,
						   IN void * data, 
						   IN unsigned long datasz,
						   IN unsigned long stacksz);
typedef unsigned long SOMLINK somTD_SOMEndThread(void);
typedef unsigned long SOMLINK somTD_SOMKillThread(IN somToken thrd);
typedef unsigned long SOMLINK somTD_SOMYieldThread(void);
typedef unsigned long SOMLINK somTD_SOMGetThreadHandle(OUT somToken * thrd);

/* pointers to thread service functions */
#if defined(_WIN32) && !defined(_WIN32_SOMU) 
SOMEXTERN WIN32_DLLIMPORT somTD_SOMStartThread     * SOMDLINK SOMStartThread;
SOMEXTERN WIN32_DLLIMPORT somTD_SOMEndThread       * SOMDLINK SOMEndThread;
SOMEXTERN WIN32_DLLIMPORT somTD_SOMKillThread      * SOMDLINK SOMKillThread;
SOMEXTERN WIN32_DLLIMPORT somTD_SOMYieldThread     * SOMDLINK SOMYieldThread;
SOMEXTERN WIN32_DLLIMPORT somTD_SOMGetThreadHandle * SOMDLINK SOMGetThreadHandle;
#else
SOMEXTERN somTD_SOMStartThread     * SOMDLINK SOMStartThread;
SOMEXTERN somTD_SOMEndThread       * SOMDLINK SOMEndThread;
SOMEXTERN somTD_SOMKillThread      * SOMDLINK SOMKillThread;
SOMEXTERN somTD_SOMYieldThread     * SOMDLINK SOMYieldThread;
SOMEXTERN somTD_SOMGetThreadHandle * SOMDLINK SOMGetThreadHandle;
#endif /* !_WIN32 */


#endif /* SOM_somthrd_h */



