/********************************************************************/
/*  <excpt.h> header file                                           */
/*                                                                  */
/*  VisualAge for C++ for Windows, Version 3.5                      */
/*    Licensed Material - Property of IBM                           */
/*                                                                  */
/*  5801-ARR and Other Materials                                    */
/*                                                                  */
/*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
/*                                                                  */
/********************************************************************/

#ifndef __excpt_h
   #define __excpt_h

   #ifdef __cplusplus
      extern "C" {
   #endif

   #ifndef  _LNK_CONV
      #ifdef _M_I386
         #define _LNK_CONV   _Optlink
      #else
         #define _LNK_CONV
      #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /*
    * Exception disposition return values.
    */
   typedef enum _EXCEPTION_DISPOSITION {
      ExceptionContinueExecution,
      ExceptionContinueSearch,
      ExceptionNestedException,
      ExceptionCollidedUnwind,
      _ExceptionDummyDisposition = 0x10000000 /* make sure it is 4 bytes wide */
   } EXCEPTION_DISPOSITION;


   /*
    * Legal values for expression in except().
    */

   #define EXCEPTION_EXECUTE_HANDLER     1
   #define EXCEPTION_CONTINUE_SEARCH     0
   #define EXCEPTION_CONTINUE_EXECUTION -1

   #ifndef __cplusplus
      extern unsigned long _Builtin  _exception_code(void);
      extern void* _IMPORT _LNK_CONV _GetExceptionInfo(void);
      extern int   _IMPORT _LNK_CONV _AbnormalTermination(void);
      struct _EXCEPTION_POINTERS;

      #define GetExceptionCode        _exception_code
      #define exception_code          _exception_code
      #define GetExceptionInformation (struct _EXCEPTION_POINTERS *)_GetExceptionInfo
      #define exception_info          (struct _EXCEPTION_POINTERS *)_GetExceptionInfo
      #define AbnormalTermination     _AbnormalTermination
      #define abnormal_termination    _AbnormalTermination
   #endif

   #ifdef __cplusplus
      }
   #endif

#endif  /* __excpt_h */

