#ifndef _I0STRING_INL_
#define _I0STRING_INL_ 0
/*******************************************************************************
* FILE NAME: i0string.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in i0string.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _I0STRING_
  #undef  _I0STRING_INL_
  #define _I0STRING_INL_ 1
  #include <i0string.hpp>
#endif

#include <istrtest.hpp>

#if _I0STRING_INL_
  #define inline
#endif

inline unsigned I0String :: adjustArg ( unsigned argIndex )
  {
  return argIndex + 1;
  }
inline unsigned I0String :: adjustResult ( unsigned resIndex )
  {
  return resIndex - 1;
  }

inline signed I0String :: adjustArg ( signed argIndex )
  {
  return argIndex + 1;
  }
inline signed I0String :: adjustResult ( signed resIndex )
  {
  return resIndex - 1;
  }

inline I0String :: I0String ( )
  : IString( )
  {
  }
inline I0String :: I0String ( const IString &aString )
  : IString( aString )
  {
  }
inline I0String :: I0String ( int anInt )
  : IString( anInt )
  {
  }
inline I0String :: I0String ( unsigned anUnsigned )
  : IString( anUnsigned )
  {
  }
inline I0String :: I0String ( long aLong )
  : IString( aLong )
  {
  }
inline I0String :: I0String ( unsigned long anUnsignedLong )
  : IString( anUnsignedLong )
  {
  }
#ifdef _LONG_LONG
inline I0String :: I0String ( long long aLongLong )
  : IString( aLongLong )
  {
  }
inline I0String :: I0String ( unsigned long long anUnsignedLongLong )
  : IString( anUnsignedLongLong )
  {
  }
#endif
inline I0String :: I0String ( short aShort )
  : IString( aShort )
  {
  }
inline I0String :: I0String ( unsigned short anUnsignedShort )
  : IString( anUnsignedShort )
  {
  }
inline I0String :: I0String ( double aDouble )
  : IString( aDouble )
  {
  }
inline I0String :: I0String ( char aChar )
  : IString( aChar )
  {
  }
inline I0String :: I0String ( unsigned char anUnsignedChar )
  : IString( anUnsignedChar )
  {
  }
inline I0String :: I0String ( signed char aSignedChar )
  : IString( aSignedChar )
  {
  }
inline I0String :: I0String ( const char *pChar )
  : IString( pChar )
  {
  }
inline I0String :: I0String ( const unsigned char *pUnsignedChar )
  : IString( pUnsignedChar )
  {
  }
inline I0String :: I0String ( const signed char *pSignedChar )
  : IString( pSignedChar )
  {
  }
inline I0String :: I0String ( const void *p1,
                              unsigned    len1,
                              char        padChar )
  : IString( p1, len1, padChar )
  {
  }
inline I0String :: I0String ( const void *p1,
                              unsigned    len1,
                              const void *p2,
                              unsigned    len2,
                              char        padChar )
  : IString( p1, len1, p2, len2, padChar )
  {
  }
inline I0String :: I0String ( const void *p1,
                              unsigned    len1,
                              const void *p2,
                              unsigned    len2,
                              const void *p3,
                              unsigned    len3,
                              char        padChar )
  : IString( p1, len1, p2, len2, p3, len3, padChar )
  {
  }

inline I0String I0String :: subString ( unsigned startPos ) const
  {
  return IString::subString( adjustArg( startPos ) );
  }
inline I0String I0String :: subString ( unsigned startPos,
                                        unsigned len,
                                        char     padChar ) const
  {
  return IString::subString( adjustArg( startPos ), len, padChar );
  }
inline char &I0String :: operator [] ( unsigned index )
  {
  return IString::operator[]( adjustArg( index ) );
  }
inline const char &I0String :: operator [] ( unsigned index ) const
  {
  return IString::operator[]( adjustArg( index ) );
  }
inline char &I0String :: operator [] ( signed index )
  {
  return IString::operator[]( adjustArg( index ) );
  }
inline const char &I0String :: operator [] ( signed index ) const
  {
  return IString::operator[]( adjustArg( index ) );
  }
inline char &I0String :: operator [] ( unsigned long index )
  {
  return IString::operator[]( adjustArg( (unsigned) index ) );
  }
inline const char &I0String :: operator [] ( unsigned long index ) const
  {
  return IString::operator[]( adjustArg( (unsigned) index ) );
  }
inline char &I0String :: operator [] ( signed long index )
  {
  return IString::operator[]( adjustArg( (signed) index ) );
  }
inline const char &I0String :: operator [] ( signed long index ) const
  {
  return IString::operator[]( adjustArg( (signed) index ) );
  }
inline IStringEnum::CharType I0String :: charType ( unsigned index ) const
  {
  return IString::charType( adjustArg( index ) );
  }

inline unsigned I0String :: indexOf ( const IString &aString,
                                      unsigned       startPos ) const
  {
  return adjustResult( IString::indexOf( aString, adjustArg( startPos ) ) );
  }
inline unsigned I0String :: indexOf ( const char *pString,
                                      unsigned    startPos ) const
  {
  return adjustResult( IString::indexOf( pString, adjustArg( startPos ) ) );
  }
inline unsigned I0String :: indexOf ( char     aChar,
                                      unsigned startPos ) const
  {
  return adjustResult( IString::indexOf( aChar, adjustArg( startPos ) ) );
  }
inline unsigned I0String :: indexOf ( const IStringTest &aTest,
                                      unsigned           startPos ) const
  {
  return adjustResult( IString::indexOf( aTest, adjustArg( startPos ) ) );
  }
inline unsigned I0String :: indexOfAnyBut ( const IString &aString,
                                            unsigned       startPos ) const
  {
  return adjustResult( IString::indexOfAnyBut( aString,
                                               adjustArg( startPos ) ) );
  }
inline unsigned I0String :: indexOfAnyBut ( const char *pString,
                                            unsigned    startPos ) const
  {
  return adjustResult( IString::indexOfAnyBut( pString,
                                               adjustArg( startPos ) ) );
  }
inline unsigned I0String :: indexOfAnyBut ( char     aChar,
                                            unsigned startPos ) const
  {
  return adjustResult( IString::indexOfAnyBut( aChar,
                                               adjustArg( startPos ) ) );
  }
inline unsigned I0String :: indexOfAnyBut ( const IStringTest &aTest,
                                            unsigned           startPos ) const
  {
  return adjustResult( IString::indexOfAnyBut( aTest,
                                               adjustArg( startPos ) ) );
  }
inline unsigned I0String :: indexOfAnyOf ( const IString &aString,
                                           unsigned       startPos ) const
  {
  return adjustResult( IString::indexOfAnyOf( aString,
                                              adjustArg( startPos ) ) );
  }
inline unsigned I0String :: indexOfAnyOf ( const char *pString,
                                           unsigned    startPos ) const
  {
  return adjustResult( IString::indexOfAnyOf( pString,
                                              adjustArg( startPos ) ) );
  }
inline unsigned I0String :: indexOfAnyOf ( char     aChar,
                                           unsigned startPos ) const
  {
  return adjustResult( IString::indexOfAnyOf( aChar,
                                              adjustArg( startPos ) ) );
  }
inline unsigned I0String :: indexOfAnyOf ( const IStringTest &aTest,
                                           unsigned           startPos ) const
  {
  return adjustResult( IString::indexOfAnyOf( aTest,
                                              adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOf ( const IString &aString,
                                          unsigned       startPos ) const
  {
  return adjustResult( IString::lastIndexOf( aString,
                                             adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOf ( const char *pString,
                                          unsigned    startPos ) const
  {
  return adjustResult( IString::lastIndexOf( pString,
                                             adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOf ( char     aChar,
                                          unsigned startPos ) const
  {
  return adjustResult( IString::lastIndexOf( aChar,
                                             adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOf ( const IStringTest &aTest,
                                          unsigned           startPos ) const
  {
  return adjustResult( IString::lastIndexOf( aTest,
                                             adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOfAnyBut ( const IString &aString,
                                                unsigned       startPos ) const
  {
  return adjustResult( IString::lastIndexOfAnyBut( aString,
                                                   adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOfAnyBut ( const char *pString,
                                                unsigned    startPos ) const
  {
  return adjustResult( IString::lastIndexOfAnyBut( pString,
                                                   adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOfAnyBut ( char     aChar,
                                                unsigned startPos ) const
  {
  return adjustResult( IString::lastIndexOfAnyBut( aChar,
                                                   adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOfAnyBut ( const IStringTest &aTest,
                                                unsigned      startPos ) const
  {
  return adjustResult( IString::lastIndexOfAnyBut( aTest,
                                                   adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOfAnyOf ( const IString &aString,
                                               unsigned       startPos ) const
  {
  return adjustResult( IString::lastIndexOfAnyOf( aString,
                                                  adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOfAnyOf ( const char *pString,
                                               unsigned    startPos ) const
  {
  return adjustResult( IString::lastIndexOfAnyOf( pString,
                                                  adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOfAnyOf ( char     aChar,
                                               unsigned startPos ) const
  {
  return adjustResult( IString::lastIndexOfAnyOf( aChar,
                                                  adjustArg( startPos ) ) );
  }
inline unsigned I0String :: lastIndexOfAnyOf ( const IStringTest &aTest,
                                               unsigned       startPos ) const
  {
  return adjustResult( IString::lastIndexOfAnyOf( aTest,
                                                  adjustArg( startPos ) ) );
  }
inline unsigned I0String :: occurrencesOf ( const IString &aString,
                                            unsigned       startPos ) const
  {
  return IString::occurrencesOf( aString,
                                 adjustArg( startPos ) );
  }
inline unsigned I0String :: occurrencesOf ( const char    *pString,
                                            unsigned       startPos ) const
  {
  return IString::occurrencesOf( pString,
                                 adjustArg( startPos ) );
  }
inline unsigned I0String :: occurrencesOf ( char     aChar,
                                            unsigned startPos ) const
  {
  return IString::occurrencesOf( aChar,
                                 adjustArg( startPos ) );
  }
inline unsigned I0String :: occurrencesOf ( const IStringTest &aTest,
                                            unsigned           startPos ) const
  {
  return IString::occurrencesOf( aTest,
                                 adjustArg( startPos ) );
  }
inline I0String &I0String :: change ( const IString &aPattern,
                                      const IString &aReplacement,
                                      unsigned       startPos,
                                      unsigned       numChanges )
  {
  IString::change( aPattern,
                   aReplacement,
                   adjustArg( startPos ),
                   numChanges );

  return *this;
  }
inline I0String &I0String :: change ( const IString &aPattern,
                                      const char    *pReplacement,
                                      unsigned       startPos,
                                      unsigned       numChanges )
  {
  IString::change( aPattern,
                   pReplacement,
                   adjustArg( startPos ),
                   numChanges );

  return *this;
  }
inline I0String &I0String :: change ( const char    *pPattern,
                                      const IString &aReplacement,
                                      unsigned       startPos,
                                      unsigned       numChanges )
  {
  IString::change( pPattern,
                   aReplacement,
                   adjustArg( startPos ),
                   numChanges );
  return *this;
  }
inline I0String &I0String :: change ( const char    *pPattern,
                                      const char    *pReplacement,
                                      unsigned       startPos,
                                      unsigned       numChanges )
  {
  IString::change( pPattern,
                   pReplacement,
                   adjustArg( startPos ),
                   numChanges );
  return *this;
  }
inline I0String &I0String :: insert ( const IString &aString,
                                      unsigned       index,
                                      char           padCharacter )
  {
  IString::insert( aString, adjustArg( index ), padCharacter );
  return *this;
  }
inline I0String &I0String :: insert ( const char    *pString,
                                      unsigned       index,
                                      char           padCharacter )
  {
  IString::insert( pString, adjustArg( index ), padCharacter );
  return *this;
  }
inline I0String &I0String :: overlayWith ( const IString &aString,
                                           unsigned       index,
                                           char           padCharacter )
  {
  IString::overlayWith( aString, adjustArg( index ), padCharacter );
  return *this;
  }
inline I0String &I0String :: overlayWith ( const char    *pString,
                                           unsigned       index,
                                           char           padCharacter )
  {
  IString::overlayWith( pString, adjustArg( index ), padCharacter );
  return *this;
  }
inline I0String &I0String :: remove ( unsigned startPos )
  {
  IString::remove( startPos == (unsigned)UINT_MAX ?
                   startPos : adjustArg( startPos ) );
  return *this;
  }
inline I0String &I0String :: remove ( unsigned startPos,
                                      unsigned numChars )
  {
  IString::remove( startPos == (unsigned)UINT_MAX ?
                   startPos : adjustArg( startPos ), numChars );
  return *this;
  }
inline I0String I0String :: change ( const IString &aString,
                                     const IString &inputString,
                                     const IString &outputString,
                                     unsigned       startPos,
                                     unsigned       numChanges )
  {
  I0String result( aString );
  return result.change( inputString, outputString, startPos, numChanges );
  }
inline I0String I0String :: change ( const IString &aString,
                                     const IString &inputString,
                                     const char    *pOutputString,
                                     unsigned       startPos,
                                     unsigned       numChanges)
  {
  I0String result( aString );
  return result.change( inputString, pOutputString, startPos, numChanges );
  }
inline I0String I0String :: change ( const IString &aString,
                                     const char    *pInputString,
                                     const IString &outputString,
                                     unsigned       startPos,
                                     unsigned       numChanges)
  {
  I0String result( aString );
  return result.change( pInputString, outputString, startPos, numChanges );
  }
inline I0String I0String :: change ( const IString &aString,
                                     const char    *pInputString,
                                     const char    *pOutputString,
                                     unsigned       startPos,
                                     unsigned       numChanges )
  {
  I0String result( aString );
  return result.change( pInputString, pOutputString, startPos, numChanges );
  }
inline I0String I0String :: insert ( const IString &aString,
                                     const IString &anInsert,
                                     unsigned       index,
                                     char           padCharacter )
  {
  I0String result( aString );
  return result.insert( anInsert, index, padCharacter );
  }
inline I0String I0String :: insert ( const IString &aString,
                                     const char    *pInsert,
                                     unsigned       index,
                                     char           padCharacter )
  {
  I0String result( aString );
  return result.insert( pInsert, index, padCharacter );
  }
inline I0String I0String :: overlayWith ( const IString &aString,
                                          const IString &anOverlay,
                                          unsigned       index,
                                          char           padCharacter )
  {
  I0String result( aString );
  return result.overlayWith( anOverlay, index, padCharacter );
  }
inline I0String I0String :: overlayWith ( const IString &aString,
                                          const char    *pOverlay,
                                          unsigned       index,
                                          char           padCharacter )
  {
  I0String result( aString );
  return result.overlayWith( pOverlay, index, padCharacter );
  }
inline I0String I0String :: remove ( const IString &aString,
                                     unsigned       startPos )
  {
  I0String result( aString );
  return result.remove( startPos );
  }
inline I0String I0String :: remove ( const IString &aString,
                                     unsigned       startPos,
                                     unsigned       numChars )
  {
  I0String result( aString );
  return result.remove( startPos, numChars );
  }
inline unsigned I0String :: indexOfPhrase ( const IString &wordString,
                                            unsigned       startWord ) const
  {
  return adjustResult( IString::indexOfPhrase( wordString, startWord ) );
  }
inline unsigned I0String :: indexOfWord ( unsigned wordNumber ) const
  {
  return adjustResult( IString::indexOfWord( wordNumber ) );
  }
#endif // _I0STRING_INL_
