/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IABAG_H
#define _IABAG_H

#include <iaequal.h>
#include <iiabag.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IABag :
  public IAEqualityCollection <Element> {

  typedef  IAEqualityCollection <Element> Inherited;

  typedef  IABagImpl Implementation;

public:

           IABag
                            (INotifier&);

          ~IABag
                            ();

  void     addDifference    (IABag <Element> const&,
                             IABag <Element> const&); 

  void     addIntersection  (IABag <Element> const&,
                             IABag <Element> const&);

  void     addUnion         (IABag <Element> const&,
                             IABag <Element> const&);

  void     differenceWith   (IABag <Element> const&);

  void     intersectionWith (IABag <Element> const&);

  INumber  numberOfDifferentElements
                            () const;

  IBoolean setToNextDifferentElement
                            (ICursor&) const;

  void     unionWith        (IABag <Element> const&);

  IBoolean operator==       (IABag
                              <Element> const&) const;

  IBoolean operator!=       (IABag
                              <Element> const&) const;

protected:

           IABag
                            ();

           IABag
                            (IABag <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IABag <Element> const&);


};

#include <iabag.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
