#ifndef _IACCELKY_
  #define _IACCELKY_
/*******************************************************************************
* FILE NAME: iaccelky.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IAcceleratorKey                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <icmd.hpp>
#include <ikey.hpp>


class IAcceleratorKeyData;
class IString;
struct _ACCEL;
struct tagACCEL;
typedef struct tagACCEL ACCEL;

#pragma pack(4)

class IAcceleratorKey : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IAcceleratorKey ( IKey::VirtualKey         virtualKey,
                    const IKey::KeyModifier& modifier,
                    ICommand::ActionType     actionType = ICommand::applicationCommand,
                    ICommand::CommandId      commandId = 0 );
  IAcceleratorKey ( const IString&           characterKey,
                    const IKey::KeyModifier& modifier,
                    ICommand::ActionType     actionType = ICommand::applicationCommand,
                    ICommand::CommandId      commandId = 0 );
  IAcceleratorKey ( const ACCEL&             accelerator );
  IAcceleratorKey ( const IAcceleratorKey&   key );
IAcceleratorKey
 &operator=       ( const IAcceleratorKey&   key );

 ~IAcceleratorKey ( );

/*------------------------------- Comparisons --------------------------------*/
Boolean
  operator== ( const IAcceleratorKey& key ) const,
  operator!= ( const IAcceleratorKey& key ) const,
  isLike     ( const IAcceleratorKey& key ) const;

/*----------------------------- Key Definitions ------------------------------*/
IAcceleratorKey
 &setKey         ( const IString&           accelKey,
                   const IKey::KeyModifier& modifier = IKey::noModifier ),
 &setKey         ( IKey::VirtualKey         virtualKey,
                   const IKey::KeyModifier& modifier = IKey::noModifier );
IString
  character      ( ) const;
IKey::VirtualKey
  virtualKey     ( ) const;
IKey::KeyModifier
  keyModifier    ( ) const;

/*---------------------------- Action Definitions ----------------------------*/
IAcceleratorKey
 &setCommand       ( ICommand::CommandId commandId ),
 &setSystemCommand ( ICommand::CommandId commandId ),
 &setHelpKey       ( );

ICommand::ActionType
  actionType       ( ) const;

ICommand::CommandId
  commandId        ( ) const;

/*------------------------------- Conversions --------------------------------*/
ACCEL
  asACCEL        ( ) const;

protected:
/*-------------------------------- Identifier --------------------------------*/
static unsigned long
  uniqueKeyFor   ( const IAcceleratorKey& key );

private:
/*--------------------------------- Private ----------------------------------*/
friend unsigned long const
 &key            ( IAcceleratorKey const&   item );
IAcceleratorKey
 &setKeyModifier ( const IKey::KeyModifier& modifier );
IAcceleratorKeyData
 *fData;
};  // IAcceleratorKey

#pragma pack()

  #include <iaccelky.inl>

#endif /* _IACCELKY_ */
