#ifndef _IACCELTB_
  #define _IACCELTB_
/*******************************************************************************
* FILE NAME: iacceltb.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IAcceleratorTable                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ivbase.hpp>


class IAcceleratorKey;
class IAcceleratorTableCursorData;
class IAcceleratorTableData;
class IAccelTblHandle;
class IResourceId;
class IWindow;
class IWindowHandle;

#pragma pack(4)

class IAcceleratorTable : public IBase {
typedef IBase
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  IAcceleratorTable ( const IWindow*           window = 0 );
  IAcceleratorTable ( const IAccelTblHandle&   accelTblHandle );
  IAcceleratorTable ( const IResourceId&       resId );

  IAcceleratorTable ( const IAcceleratorTable& accelTbl );
IAcceleratorTable
 &operator=         ( const IAcceleratorTable& accelTbl );
 ~IAcceleratorTable ( );

/*----------------------------- Handle Management ----------------------------*/
IAccelTblHandle
  handle        ( ) const;
static void
  destroyHandle ( IAccelTblHandle& accelTblHandle );

/*------------------------------- Nested Types -------------------------------*/
class Cursor : public IVBase {
  typedef IVBase
    Inherited;
  public:
  /*------------------------------ Constructors ------------------------------*/
    Cursor ( IAcceleratorTable& accelTbl );
  virtual
   ~Cursor ( );

  /*---------------------------- Cursor Functions ----------------------------*/
  virtual Boolean
    setToFirst ( ),
    setToNext  ( ),
    isValid    ( ) const;
  virtual void
    invalidate ( );
  IAcceleratorKey
    element    ( ) const;

  private:
  /*---------------------------- Hidden Functions ----------------------------*/
    Cursor    ( const Cursor& cursor );
  Cursor
   &operator= ( const Cursor& cursor );

  /*-------------------------------- Private ---------------------------------*/
  friend class IAcceleratorTable;
  IAcceleratorTableCursorData
   *fData;
  };  // IAcceleratorTable::Cursor

/*------------------------------ Querying Keys -------------------------------*/
static IAcceleratorKey
  keyAt           ( const Cursor&          cursor );
Boolean
  containsKeyLike ( const IAcceleratorKey& key ) const,
  locateKeyLike   ( const IAcceleratorKey& key,
                    Cursor&                cursor ) const;
unsigned long
  keyCount        ( ) const;

/*------------------------------ Changing Keys -------------------------------*/
IAcceleratorTable
 &removeKeyAt     ( Cursor&                cursor,
                    Boolean                updateWindow = true ),
 &removeAllKeys   ( Boolean                updateWindow = true ),
 &replaceKeyAt    ( const Cursor&          cursor,
                    const IAcceleratorKey& newKey,
                    Boolean                updateWindow = true );
Boolean
  addKey          ( const IAcceleratorKey& newKey,
                    Boolean                updateWindow = true ),
  addOrReplaceKey ( const IAcceleratorKey& newKey,
                    Boolean                updateWindow = true ),
  removeKeyLike   ( const IAcceleratorKey& key,
                    Boolean                updateWindow = true );

private:
/*--------------------------------- Private ----------------------------------*/
IAcceleratorTable
 &initialize   ( const IAccelTblHandle& accelTblHandle );
Boolean
  updateWindow ( );
friend class IAcceleratorList;
friend class IAcceleratorTable::Cursor;
IAcceleratorTableData
 *fData;
};  // IAcceleratorTable

#pragma pack()

#endif /* _IACCELTB_ */
