/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IADeque
// ---

template <class Element>
inline
IADeque <Element>::
IADeque (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IADeque <Element>::
~IADeque ()
{
}

template <class Element>
inline void
IADeque <Element>::
addAsFirst (Element const& element)
{ ImplOf (*this).AddAsFirst (&element);
}

template <class Element>
inline void
IADeque <Element>::
addAsFirst (Element const& element, ICursor& cursor)
{ ImplOf (*this).AddAsFirst (&element, CrsrImplOf (cursor));
}

template <class Element>
inline void
IADeque <Element>::
addAsLast (Element const& element)
{ ImplOf (*this).AddAsLast (&element);
}

template <class Element>
inline void
IADeque <Element>::
addAsLast (Element const& element, ICursor& cursor)
{ ImplOf (*this).AddAsLast (&element, CrsrImplOf (cursor));
}

template <class Element>
inline long
IADeque <Element>::
compare (IADeque <Element> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

template <class Element>
inline void
IADeque <Element>::
removeFirst ()
{ ImplOf (*this).RemoveFirst ();
}

template <class Element>
inline void
IADeque <Element>::
removeLast ()
{ ImplOf (*this).RemoveLast ();
}

// protected members

template <class Element>
inline
IADeque <Element>::
IADeque ()
{
}

template <class Element>
inline
IADeque <Element>::
IADeque (IADeque <Element> const& collection)
: Inherited (collection)
{
}

// private members

template <class Element>
inline IADeque <Element>::Implementation&
IADeque <Element>::
ImplOf (IADeque <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
