/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAES_H
#define _IAES_H

#include <iasqntl.h>
#include <iaequal.h>
#include <iiaes.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IAEqualitySequence :
  public IAEqualityCollection <Element>,
  public IASequentialCollection <Element> {

  typedef  IASequentialCollection <Element> Inherited;

  typedef  IAEqualitySequenceImpl Implementation;

public:

           IAEqualitySequence
                            (INotifier&);

          ~IAEqualitySequence
                            ();

  long     compare          (IAEqualitySequence <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
  IBoolean locateFirst      (Element const&, ICursor&) const;

  IBoolean locateLast       (Element const&, ICursor&) const;

  IBoolean locatePrevious   (Element const&, ICursor&) const;

  IBoolean operator==       (IAEqualitySequence
                              <Element> const&) const;

  IBoolean operator!=       (IAEqualitySequence
                              <Element> const&) const;

protected:

           IAEqualitySequence
                            ();

           IAEqualitySequence
                            (IAEqualitySequence <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAEqualitySequence <Element> const&);


};

#include <iaes.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
