/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IAEqualitySequence
// ---

template <class Element>
inline
IAEqualitySequence <Element>::
IAEqualitySequence (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element>
inline
IAEqualitySequence <Element>::
~IAEqualitySequence ()
{
}

template <class Element>
inline long
IAEqualitySequence <Element>::
compare (IAEqualitySequence <Element> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

template <class Element>
inline IBoolean
IAEqualitySequence <Element>::
locateFirst (Element const& element, ICursor& cursor) const
{ return ImplOf (*this).LocateFirst (&element, CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IAEqualitySequence <Element>::
locateLast (Element const& element, ICursor& cursor) const
{ return ImplOf (*this).LocateLast (&element, CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IAEqualitySequence <Element>::
locatePrevious (Element const& element, ICursor& cursor) const
{ return ImplOf (*this).LocatePrevious (&element, CrsrImplOf (cursor));
}

template <class Element>
inline IBoolean
IAEqualitySequence <Element>::
operator== (IAEqualitySequence <Element> const& collection) const
{ return ImplOf (*this).operator== (ImplOf (collection));
}

template <class Element>
inline IBoolean
IAEqualitySequence <Element>::
operator!= (IAEqualitySequence <Element> const& collection) const
{ return ImplOf (*this).operator!= (ImplOf (collection));
}

// protected members

template <class Element>
inline
IAEqualitySequence <Element>::
IAEqualitySequence ()
{
}

template <class Element>
inline
IAEqualitySequence <Element>::
IAEqualitySequence (IAEqualitySequence <Element> const& collection)
: Inherited (collection)
{
}

// private members

template <class Element>
inline IAEqualitySequence <Element>::Implementation&
IAEqualitySequence <Element>::
ImplOf (IAEqualitySequence <Element> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
