/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAKEY_H
#define _IAKEY_H

#include <iacllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key>
class IAKeyCollection : public virtual IACollection <Element> {

  typedef  IACollectionImpl Implementation;

public:

           IAKeyCollection  (INotifier&);

          ~IAKeyCollection  ();

  IBoolean addOrReplaceElementWithKey
                            (Element const&);

  IBoolean addOrReplaceElementWithKey
                            (Element const&, ICursor&);

  IBoolean containsAllKeysFrom
                            (IACollection <Element> const&) const; 

  IBoolean containsElementWithKey
                            (Key const&) const;

  Element& elementWithKey   (Key const&);

  Element const&
           elementWithKey   (Key const&) const;

  Key const&
           key              (Element const&) const;

  IBoolean locateElementWithKey
                            (Key const&, ICursor&) const;

  IBoolean locateNextElementWithKey
                            (Key const&, ICursor&) const;

  IBoolean locateOrAddElementWithKey
                            (Element const&);

  IBoolean locateOrAddElementWithKey
                            (Element const&, ICursor&);

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;

  INumber  removeAllElementsWithKey
                            (Key const&);

  IBoolean removeElementWithKey
                            (Key const&);

  IBoolean replaceElementWithKey
                            (Element const&);

  IBoolean replaceElementWithKey
                            (Element const&, ICursor&);

  IBoolean setToNextWithDifferentKey
                            (ICursor&) const;

protected:

           IAKeyCollection  ();

           IAKeyCollection  (IAKeyCollection <Element, Key> const&);

private:

  static
  Implementation&
           ImplOf           (IAKeyCollection <Element, Key> const&);


};

#pragma SOMAsDefault (pop)

#include <iakey.inl>

#pragma info (restore)
#pragma pack ()

#endif
