/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAKSB_H
#define _IAKSB_H

#include <iaksrt.h>
#include <iiaksb.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key>
class IAKeySortedBag :
  public IAKeySortedCollection <Element, Key> {

  typedef  IAKeySortedCollection <Element, Key> Inherited;

  typedef  IAKeySortedBagImpl Implementation;

public:

           IAKeySortedBag
                            (INotifier&);

          ~IAKeySortedBag
                            ();

  long     compare          (IAKeySortedBag <Element, Key> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
protected:

           IAKeySortedBag
                            ();

           IAKeySortedBag
                            (IAKeySortedBag <Element, Key> const&);

private:

  static
  Implementation&
           ImplOf           (IAKeySortedBag <Element, Key> const&);


};

#include <iaksb.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
