/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IAKeySortedBag
// ---

template <class Element, class Key>
inline
IAKeySortedBag <Element, Key>::
IAKeySortedBag (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element, class Key>
inline
IAKeySortedBag <Element, Key>::
~IAKeySortedBag ()
{
}

template <class Element, class Key>
inline long
IAKeySortedBag <Element, Key>::
compare (IAKeySortedBag <Element, Key> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

// protected members

template <class Element, class Key>
inline
IAKeySortedBag <Element, Key>::
IAKeySortedBag ()
{
}

template <class Element, class Key>
inline
IAKeySortedBag <Element, Key>::
IAKeySortedBag (IAKeySortedBag <Element, Key> const& collection)
: Inherited (collection)
{
}

// private members

template <class Element, class Key>
inline IAKeySortedBag <Element, Key>::Implementation&
IAKeySortedBag <Element, Key>::
ImplOf (IAKeySortedBag <Element, Key> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
