/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAKSS_H
#define _IAKSS_H

#include <iaksrt.h>
#include <iiakss.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key>
class IAKeySortedSet :
  public IAKeySortedCollection <Element, Key> {

  typedef  IAKeySortedCollection <Element, Key> Inherited;

  typedef  IAKeySortedSetImpl Implementation;

public:

           IAKeySortedSet
                            (INotifier&);

          ~IAKeySortedSet
                            ();

  long     compare          (IAKeySortedSet <Element, Key> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 
protected:

           IAKeySortedSet
                            ();

           IAKeySortedSet
                            (IAKeySortedSet <Element, Key> const&);

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;

  INumber  removeAllElementsWithKey
                            (Key const&);

  IBoolean setToNextWithDifferentKey
                            (ICursor&) const;

private:

  static
  Implementation&
           ImplOf           (IAKeySortedSet <Element, Key> const&);


};

#include <iakss.inl>

#pragma SOMAsDefault (pop)

#pragma info (restore)
#pragma pack ()

#endif
