/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IAKeySortedSet
// ---

template <class Element, class Key>
inline
IAKeySortedSet <Element, Key>::
IAKeySortedSet (INotifier& notifier)
{ SetImpl ((Implementation*)&notifier);
}

template <class Element, class Key>
inline
IAKeySortedSet <Element, Key>::
~IAKeySortedSet ()
{
}

template <class Element, class Key>
inline long
IAKeySortedSet <Element, Key>::
compare (IAKeySortedSet <Element, Key> const& collection,
         long (*compFunc) (Element const&, Element const&)) const
{ return ImplOf (*this).
    Compare (ImplOf (collection), (ICompFunc)compFunc, 0);
}

// protected members

template <class Element, class Key>
inline
IAKeySortedSet <Element, Key>::
IAKeySortedSet ()
{
}

template <class Element, class Key>
inline
IAKeySortedSet <Element, Key>::
IAKeySortedSet (IAKeySortedSet <Element, Key> const& collection)
: Inherited (collection)
{
}

template <class Element, class Key>
inline INumber
IAKeySortedSet <Element, Key>::
numberOfDifferentKeys () const
{ return IAKeyCollection <Element, Key>::numberOfDifferentKeys ();
}

template <class Element, class Key>
inline INumber
IAKeySortedSet <Element, Key>::
numberOfElementsWithKey (Key const& key) const
{ return IAKeyCollection <Element, Key>::numberOfElementsWithKey (key);
}

template <class Element, class Key>
inline INumber
IAKeySortedSet <Element, Key>::
removeAllElementsWithKey (Key const& key)
{ return IAKeyCollection <Element, Key>::removeAllElementsWithKey (key);
}

template <class Element, class Key>
inline IBoolean
IAKeySortedSet <Element, Key>::
setToNextWithDifferentKey (ICursor& cursor) const
{ return
    IAKeyCollection <Element, Key>::setToNextWithDifferentKey (cursor);
}

// private members

template <class Element, class Key>
inline IAKeySortedSet <Element, Key>::Implementation&
IAKeySortedSet <Element, Key>::
ImplOf (IAKeySortedSet <Element, Key> const& collection)
{ return *(Implementation*)collection.ivImpl;
}
