/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAMWT_H
#define _IAMWT_H

#include <iatree.h>
#include <iimwt.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <INumber numOfChildren, class Element>
class IAMultiwayTree : public IATree <Element> {

  typedef  IMultiwayTreeImpl Implementation;

public:

  void     attachAsChild    (ITreeCursor const&, IPosition,
                             IAMultiwayTree
                              <numOfChildren, Element> const&);

  void     attachAsRoot     (IAMultiwayTree
                              <numOfChildren, Element> const&);

  void     attachSubtreeAsChild
                            (ITreeCursor const&, IPosition,
                             IAMultiwayTree
                              <numOfChildren, Element> const&,
                             ITreeCursor const&);

  void     attachSubtreeAsRoot
                            (IAMultiwayTree
                              <numOfChildren, Element> const&,
                             ITreeCursor const&);

  void     copy             (IAMultiwayTree
                              <numOfChildren, Element> const&);

  void     copySubtree      (IAMultiwayTree
                              <numOfChildren, Element> const&,
                             ITreeCursor const&);

  IBoolean hasChild         (IPosition, ITreeCursor const&) const;

  INumber  numberOfChildren () const;

protected:

           IAMultiwayTree   ();

           IAMultiwayTree   (IAMultiwayTree
                              <numOfChildren, Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAMultiwayTree
                              <numOfChildren, Element> const&);


};

#pragma SOMAsDefault (pop)

#include <iamwt.inl>

#pragma info (restore)
#pragma pack ()

#endif
