/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// --------------
// IAMultiwayTree
// --------------

template <INumber numOfChildren, class Element>
inline void
IAMultiwayTree <numOfChildren, Element>::
attachAsChild (ITreeCursor const& cursor, IPosition position,
               IAMultiwayTree <numOfChildren, Element> const& tree)
{ ImplOf (*this).
    AttachAsChild (CrsrImplOf (cursor), position, ImplOf (tree));
}

template <INumber numOfChildren, class Element>
inline void
IAMultiwayTree <numOfChildren, Element>::
attachAsRoot (IAMultiwayTree <numOfChildren, Element> const& tree)
{ ImplOf (*this).AttachAsRoot (ImplOf (tree));
}

template <INumber numOfChildren, class Element>
inline void
IAMultiwayTree <numOfChildren, Element>::
attachSubtreeAsChild
  (ITreeCursor const& cursor, IPosition position,
   IAMultiwayTree <numOfChildren, Element> const& tree,
   ITreeCursor const& thatCursor)
{ ImplOf (*this).
    AttachSubtreeAsChild (CrsrImplOf (cursor), position,
                          ImplOf (tree), CrsrImplOf (thatCursor));
}

template <INumber numOfChildren, class Element>
inline void
IAMultiwayTree <numOfChildren, Element>::
attachSubtreeAsRoot
  (IAMultiwayTree <numOfChildren, Element> const& tree,
   ITreeCursor const& thatCursor)
{ ImplOf (*this).
    AttachSubtreeAsRoot (ImplOf (tree), CrsrImplOf (thatCursor));
}

template <INumber numOfChildren, class Element>
inline void
IAMultiwayTree <numOfChildren, Element>::
copy (IAMultiwayTree <numOfChildren, Element> const& tree)
{ ImplOf (*this).Copy (ImplOf (tree));
}

template <INumber numOfChildren, class Element>
inline void
IAMultiwayTree <numOfChildren, Element>::
copySubtree (IAMultiwayTree <numOfChildren, Element> const& tree,
             ITreeCursor const& thatCursor)
{ ImplOf (*this).CopySubtree (ImplOf (tree), CrsrImplOf (thatCursor));
}

template <INumber numOfChildren, class Element>
inline IBoolean
IAMultiwayTree <numOfChildren, Element>::
hasChild (IPosition position, ITreeCursor const& cursor) const
{ return ImplOf (*this).HasChild (position, CrsrImplOf (cursor));
}

template <INumber numOfChildren, class Element>
inline INumber
IAMultiwayTree <numOfChildren, Element>::
numberOfChildren () const
{ return ImplOf (*this).NumberOfChildren ();
}

// protected members

template <INumber numOfChildren, class Element>
inline
IAMultiwayTree <numOfChildren, Element>::
IAMultiwayTree ()
: IATree <Element> ()
{
}

template <INumber numOfChildren, class Element>
inline
IAMultiwayTree <numOfChildren, Element>::
IAMultiwayTree (IAMultiwayTree <numOfChildren, Element> const& tree)
: IATree <Element> (tree)
{
}

// private members

template <INumber numOfChildren, class Element>
inline IAMultiwayTree <numOfChildren, Element>::Implementation&
IAMultiwayTree <numOfChildren, Element>::
ImplOf (IAMultiwayTree <numOfChildren, Element> const& tree)
{ return *(Implementation*)tree.ivImpl;
}
