#ifndef _IANIMBUT_
#define _IANIMBUT_
/*******************************************************************************
* FILE NAME: ianimbut.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IAnimatedButton                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icustbut.hpp>
#include <irect.hpp>

class IAnimatedButtonData;
class IBitmapHandle;
class ISize;
class IResourceId;

#pragma pack(4)


class IAnimatedButton : public ICustomButton {
typedef ICustomButton
  Inherited;
public:
class Style;
/*----------------------------- Constructors ---------------------------------*/
  IAnimatedButton  ( unsigned long     id,
                     IWindow*          parent,
                     IWindow*          owner,
                     const IRectangle& initial = IRectangle(),
                     const Style&      style = defaultStyle() );

  IAnimatedButton  ( const IWindowHandle& handle );

virtual
  ~IAnimatedButton ( );

/*-------------------------------- Styles ------------------------------------*/
INESTEDBITFLAGCLASSDEF4(Style, IAnimatedButton, IWindow,
                        IControl, IButton, ICustomButton);

static const Style
  IC_IMPORTU animateWhenLatched,
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------ Animated Bitmap Identifiers -----------------------*/
enum AnimatedBitmaps {
  rewind,
  stop,
  pause,
  play,
  fastForward,
  record,
  mute,
  trackAdvance,
  trackReverse,
  stepForward,
  stepBackward,
  scanForward,
  scanBackward,
  eject,
  volumeUp,
  volumeDown
};

/*------------------------------ Bitmaps -------------------------------------*/
virtual IAnimatedButton
 &setBitmaps   ( const IResourceId& firstBitmap,
                 unsigned long      count ),
 &setBitmaps   ( AnimatedBitmaps    bitmaps );

virtual IBitmapHandle
  bitmap       ( unsigned long index = 0 ) const;

virtual unsigned long
  bitmapCount        ( ) const,
  currentBitmapIndex ( ) const;

virtual IAnimatedButton
 &setCurrentBitmapIndex ( unsigned long index = 0 );

/*-------------------------------- Animation ---------------------------------*/
unsigned long
  animationRate       ( ) const;

virtual IAnimatedButton
 &setAnimationRate    ( unsigned long newRate = 1000 ),
 &startAnimation      ( unsigned long index = 0 ),
 &stopAnimation       ( );

Boolean
  isAnimationStarted    ( ) const,
  isAnimatedWhenLatched ( ) const;

virtual IAnimatedButton
 &enableAnimateWhenLatched  ( Boolean enable = true ),
 &disableAnimateWhenLatched ( ),
 &latch                     ( Boolean latched = true,
                              Boolean refresh = true );

protected:
/*----------------------------- Layout Support -------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
  IAnimatedButton            (const IAnimatedButton&);
  IAnimatedButton& operator= (const IAnimatedButton&);
static Style
  fgCurrentDefaultStyle;
IAnimatedButtonData
 *fAnimatedButtonData;
};

INESTEDBITFLAGCLASSFUNCS(Style, IAnimatedButton);


#pragma pack()

#endif /* _IANIMBUT_ */
