/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IAORDER_H
#define _IAORDER_H

#include <iacllct.h>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element>
class IOrderedCursor : public IElementCursor <Element> {

  typedef  ICursorImpl Implementation;

public:

  IBoolean setToLast        ();

  IBoolean setToPrevious    ();

protected:

           IOrderedCursor   (Implementation*);


};

template <class Element>
class IAOrderedCollection : public virtual IACollection <Element> {

  typedef  IACollectionImpl Implementation;

public:

           IAOrderedCollection
                            (INotifier&);

          ~IAOrderedCollection
                            ();

  Element const&
           elementAtPosition
                            (IPosition) const;

  Element const&
           first            () const;

  IBoolean isFirstAt        (ICursor const&) const;

  IBoolean isLastAt         (ICursor const&) const;

  Element const&
           last             () const;

  IPosition
           positionAt       (ICursor const&) const;

  void     removeAtPosition (IPosition);

  void     removeFirst      ();

  void     removeLast       ();

  IBoolean setToLast        (ICursor&) const;

  void     setToPosition    (IPosition, ICursor&) const;

  IBoolean setToPrevious    (ICursor&) const;

  // for backward compatibility
  Element const&
           firstElement     () const;

  IBoolean isFirst          (ICursor const&) const;

  IBoolean isLast           (ICursor const&) const;

  Element const&
           lastElement      () const;

  IPosition
           position         (ICursor const&) const;

protected:

           IAOrderedCollection
                            ();

           IAOrderedCollection
                            (IAOrderedCollection <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAOrderedCollection <Element> const&);


};

#pragma SOMAsDefault (pop)

#include <iaorder.inl>

#pragma info (restore)
#pragma pack ()

#endif
