#ifndef _IAPP_
#define _IAPP_
/*******************************************************************************
* FILE NAME: iapp.hpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     IApplication                                                             *
*     ICurrentApplication                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <ihandle.hpp>

struct pib_s;
class IResourceLibrary;
class IString;
class ICurrentApplication;
class ICurrentApplicationData;

#pragma pack(4)


class IApplication : public IVBase {
typedef IVBase
  Inherited;
public:
/*-------------------------------- Diagnostics -------------------------------*/
virtual IString
  asString    ( ) const,
  asDebugInfo ( ) const;

/*---------------------------- Process Information ---------------------------*/
static IProcessId
  currentPID  ( );

virtual IProcessId
  id          ( ) const;

static ICurrentApplication
 &current     ( );

/*--------------------------------- Priority ---------------------------------*/
enum PriorityClass {
  noChange,
  idleTime,
  regular,
  timeCritical,
  foregroundServer
};

virtual IApplication
#ifndef IC_WIN_FLAGNOP
 &adjustPriority ( long          adjustment,
                   Boolean       setDescendents = false ),
#endif
 &setPriority    ( PriorityClass priorityClass,
                   long          priorityLevel = 0,
                   Boolean       setDescendents = false );

protected:
/*------------------------------- Constructors -------------------------------*/
  IApplication ( const IProcessId& id );
virtual
 ~IApplication ( );

/*------------------------ Setting Process Information -----------------------*/
virtual IApplication
  &setId ( const IProcessId& id );

private:
/*------------------------------- Private ------------------------------------*/
static ICurrentApplication
 *pCurrent;
IProcessId
  pid;
}; // IApplication


class ICurrentApplication : public IApplication {
typedef IApplication
  Inherited;
public:
/*--------------------------------- Arguments --------------------------------*/
virtual int
  argc    ( ) const;

virtual IString
  argv    ( int argumentNumber ) const;

virtual ICurrentApplication
 &setArgs ( int               argc,
            const char* const argv[] );

/*---------------------------- Resource Libraries ----------------------------*/
virtual IResourceLibrary
 &userResourceLibrary    ( ) const,
 &resourceLibrary        ( ) const;

virtual ICurrentApplication
 &setUserResourceLibrary ( const char* resLibName ),
 &setResourceLibrary     ( const char* resLibName );

/*--------------------------- Starting and Stopping --------------------------*/
virtual ICurrentApplication
 &run  ( ),
 &exit ( );

/*------------------------------- Diagnostics --------------------------------*/
virtual IString
  asDebugInfo ( ) const;

protected:
/*------------------------------- Constructors -------------------------------*/
  ICurrentApplication ( );
virtual
 ~ICurrentApplication ( );

/*---------------------------- Process Information ---------------------------*/

private:
/*-------------------------------- Private -----------------------------------*/
friend class IApplication;

IResourceLibrary
 *icluiLib,
 *userLib;

Boolean
  exeResource;

int
  argCount;

IString
 *argValue;


ICurrentApplicationData
 *pCurrentApplicationData;

}; // ICurrentAppliction

#pragma pack()

#endif /* _IAPP_ */
